package LinkFuture.Core.GenericRepository.Entity;

import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * Created by Cyokin
 * on 10/26/2015.
 */
public class GenericSet extends LinkedHashMap<String,Object> {
    public static class Builder<T extends Builder<T>>{
        private HashMap<String,Object> queryMaps = new LinkedHashMap<>();
        private GenericWhere where;
        public T set(String key,Object value){
            this.queryMaps.put(key, value);
            return (T)this;
        }
        public T where(GenericWhere where){
            this.where = where;
            return (T)this;
        }
        public GenericSet build() {
            GenericSet myQuery=new GenericSet();
            myQuery.putAll(this.queryMaps);
            if(this.where!=null && this.where.size() > 0)
            {
                myQuery.put("$where",this.where);
            }
            else
            {
                throw new IllegalArgumentException("you must have where condition for update operation");
            }
            return myQuery;
        }
    }
    public static Builder<?> builder(){
        return new Builder();
    }
}
