package LinkFuture.Core.GenericRepository.Entity;

import LinkFuture.Core.DBHelper.NewGenericDBHelper;

import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * Created by Cyokin
 * on 10/25/2015.
 */
public class GenericQuery extends LinkedHashMap<String,Object> {
    public static class Builder<T extends Builder<T>>{
        private HashMap<String,Object> queryMaps = new LinkedHashMap<>();
        private HashMap<String,Object> sortMaps = new LinkedHashMap<>();
        private GenericWhere where;
        public T query(String key){
            this.queryMaps.put(key, true);
            return (T)this;
        }
        public T limit(int limit){
            this.queryMaps.put(NewGenericDBHelper.$LIMIT, limit);
            return (T)this;
        }
        public T offset(int offset){
            this.queryMaps.put(NewGenericDBHelper.$OFFSET, offset);
            return (T)this;
        }
        public T sort(String key,GenericSort sort){
            this.sortMaps.put(key,sort);
            return (T)this;
        }
        public T where(GenericWhere where){
            this.where = where;
            return (T)this;
        }
        public GenericQuery build() {
            GenericQuery myQuery=new GenericQuery();
            myQuery.putAll(this.queryMaps);
            if(this.where!=null && this.where.size() > 0)
            {
                myQuery.put(NewGenericDBHelper.$WHERE,this.where);
            }
            if(this.sortMaps.size()>0)
            {
                myQuery.put(NewGenericDBHelper.$SORT,this.sortMaps);
            }
            return myQuery;
        }
    }
    public static Builder<?> builder(){
        return new Builder();
    }
}
