package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.*;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.*;
import java.util.Map;

/**
 * Created by Cyokin
 * on 6/23/2015.
 */
public class DBJsonReader extends DBReader {
    public DBJsonReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }
    public JSONObject Read() throws Exception {
        JSONObject root = new JSONObject();
        //PostgreSQL
        if(this.DBType == DBTypeInfo.PostgreSQL && this.statement instanceof CallableStatement)
        {
            Connection conn = this.statement.getConnection();
            for (SPParameterInfo param: this.spMetaInfo.parameterList)
            {
                if(param.isRefcursor())
                {
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(String.format("FETCH ALL IN \"%s\"",param.parameterName));
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page")) root.append("page",table.get("page"));
                    }
                }
            }
        }
        else
        {
            boolean hadResults = true;
            while(hadResults)
            {
                ResultSet rs = statement.getResultSet();
                if(rs!=null)
                {
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page"))root.append("page",table.get("page"));
                    }

                    hadResults = statement.getMoreResults();
                }
                else
                {
                    hadResults = false;
                }
            }
        }

        if(this.statement instanceof CallableStatement)
        {
            Map<String,Object> outputList = DBHelper.ReadOutputParameterList(this.spMetaInfo,(CallableStatement)this.statement,this.DBType);
            JSONObject outputParameter = new JSONObject();
            for (String key : outputList.keySet())
            {
                Object output = outputList.get(key);
                if(output instanceof ResultSet)
                {
                    ResultSet rs = (ResultSet) output;
                    JSONObject table = this.read(rs);
                    if(table.length() >0)
                    {
                        root.append("data",table.get("data"));
                        if(table.has("page"))root.append("page",table.get("page"));
                    }
                }
                else
                {
                    outputParameter.put(key,output);
                }
            }
            if(outputParameter.length()>0)
            {
                root.put("params",outputParameter);
            }
        }
        return root.length()>0?root:null;
    }
    private JSONObject read(ResultSet rs) throws Exception {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        JSONArray dataArray = new JSONArray();
        JSONObject pagerObj = new JSONObject();
        while (rs.next()) {
            JSONObject item = new JSONObject();
            for (int i = 1; i <= resultMetaInfo.columnList.size(); i++) {
                Object itemValue =  rs.getObject(i);
                if(itemValue!=null)
                {
                    ColumnInfo column =   resultMetaInfo.columnList.get(i -1);
                    //get page info
                    //TODO:hack here, need consider code structure more later
                    if(column.columnName.equalsIgnoreCase(Config.keyPageLimit))
                    {
                        pagerObj.put("limit",itemValue);
                        continue;
                    }
                    if(column.columnName.equalsIgnoreCase(Config.keyTotalCount))
                    {
                        pagerObj.put("total_count",itemValue);
                        continue;
                    }
                    if(column.columnName.equalsIgnoreCase(Config.keyPageOffset))
                    {
                        pagerObj.put("offset",itemValue);
                        continue;
                    }

                    if(column.isSqlJsonType()){
                        String jsonString = itemValue.toString().trim();
                        if(jsonString.startsWith("[") && jsonString.endsWith("]"))
                        {
                            item.put(column.columnName, new JSONArray(jsonString));
                        }
                        else
                        {
                            item.put(column.columnName, new JSONObject(jsonString));
                        }
                    }
                    else if(column.sqlType == Types.ARRAY)
                    {
                        Array sqlArray =  (Array)itemValue;
                        String arrayString = itemValue.toString();
                        //remove {}
                        arrayString = "["+  arrayString.substring(1, arrayString.length() - 1) + "]";
                        JSONArray arrayJson = new JSONArray(arrayString);
                        if(sqlArray.getBaseType()==Types.STRUCT)
                        {
                            JSONArray structJson = new JSONArray();
                            TableInfo typeInfo = DBHelper.findTypeInfo(this.statement.getConnection(), StringExtension.TrimStart(column.sqlTypeName, "_"));
                            for (int j = 0 ; j < arrayJson.length(); j++) {
                                String structString = arrayJson.getString(j);
                                //remove ()
                                structString = structString.substring(1, structString.length() - 1);
                                String[] list = structString.split(",");
                                JSONObject struct = new JSONObject();
                                for (int x=0;x<typeInfo.columnList.size();x++)
                                {
                                    struct.put(typeInfo.columnList.get(x).columnName, list[x]);
                                }
                                structJson.put(struct);
                            }
                            item.put(column.columnName, structJson);
                        }
                        else
                        {

                            item.put(column.columnName, arrayJson);
                        }
                    }
                    else if(column.sqlType == Types.STRUCT)
                    {
                        item.put(column.columnName, JsonController.sqlStructToJSON(itemValue.toString(), DBHelper.findTypeInfo(this.statement.getConnection(), column.sqlTypeName)));
                    }
                    else if(column.isSqlTimeStampType() && itemValue instanceof Timestamp)
                    {
                        item.put(column.columnName, DateExtension.UTFFormat(DateExtension.Convert((Timestamp) itemValue)) );
                    }
                    else
                    {
                        item.put(column.columnName, itemValue);
                    }
                }
            }
            dataArray.put(item);
        }
        JSONObject output = new JSONObject();
        if(dataArray.length()>0)output.put("data",dataArray);
        if(pagerObj.length()>0)output.put("page",pagerObj);
        return output;
    }
}
