package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.Extensions.XsltExtension;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import org.w3c.dom.Document;

/**
 * User: Cyokin Zhang
 * Date: 12/3/13
 * Time: 4:36 PM
 */
public class ContentXPathSelector extends ContentBaseSelector {

    public ContentXPathSelector(ContentParameterCollectionInfo parameters, ContentSelectorMeta meta) {
        super(parameters, meta);
    }

    @Override
    public Object LoadSelector() throws Exception {
        if(currentParameters.containsKey(this.meta.Source))
        {
            Debugger.LogFactory.trace("Load Selector: {}", this.meta.toString());
            Document doc = Utility.parseXmlDom(currentParameters.get(this.meta.Source).toString());
            return XsltExtension.XPathSelect(doc, this.meta.Key);
        }
        return null;
    }

    @Override
    public String BuildSelectorIdentity() throws Exception {
        return "$ContentXPathSelector$".concat(this.meta.toString());
    }
}
