package LinkFuture.Core.ContentManager.ContentSecurity;

import LinkFuture.Core.ContentManager.Model.SecurityInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/29/13
 * Time: 9:54 PM
 */
public abstract class ContentBeanBaseSecurity<T> extends ContentBaseSecurity {
    public ContentBeanBaseSecurity(SecurityInfo currentSecurity, Class<T> type) throws Exception {
        super(currentSecurity);
        if (this.CurrentSecurity != null && !StringExtension.IsNullOrEmpty(this.CurrentSecurity.Meta))
        {
            CurrentSecurity.setMetaObj(type);
            this.Meta = CurrentSecurity.getMetaObj();
        }
    }
    public T Meta;
}
