package LinkFuture.Core.ContentManager.ContentParameter;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.MemoryManager.MemoryFactory;
import LinkFuture.Init.Debugger;
import LinkFuture.Core.MemoryManager.Meta.MemoryCacheMetaInfo;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Core.OperationManager.Operation;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBaseParameter implements IContentParameter
{
    public ParameterInfo CurrentParameter;

    public ContentBaseParameter(ParameterInfo currentParameter)
    {
        this.CurrentParameter = currentParameter;
    }

    public abstract CaseInsensitiveMap<Object> GerResource(ContentParameterCollectionInfo parameters) throws Exception;
    public abstract String GerParameterIdentity(ContentParameterCollectionInfo parameters);

    public CaseInsensitiveMap<Object> GerParameter(ContentParameterCollectionInfo parameters) throws Exception {
        MemoryCacheMetaInfo meta = MemoryFactory.FindMemoryCache(this.CurrentParameter.CacheSettingKey);
        Object[] passArgs= new Object[] {parameters};
        if(meta==null)
        {
            return Callback(passArgs);
        }
        else
        {
            meta.Key  =this.GerParameterIdentity(parameters);
            meta.Action = new Operation<Object>(passArgs) {
                @Override
                public Object call() throws Exception {
                    return Callback(this.params);
                }
            };
            return StaticMemoryCacheHelper.AddMemoryCache(meta);
        }
    }
    public CaseInsensitiveMap<Object> Callback(Object... args) throws Exception {
        ContentParameterCollectionInfo parameters = (ContentParameterCollectionInfo)args[0];
        Debugger.LogFactory.trace("Retrieve Parameter: {}", this.CurrentParameter.Name);
        return GerResource(parameters);
    }
}
