/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.File;
import java.nio.file.Paths;

public class PathExtension {
    private static String applicationPath;
    private static OS cachedOS;

    public static String FullPhysicalPath(String ... paths) {
        if (PathExtension.IsAbsolute(paths[0])) {
            String[] subPath = new String[paths.length - 1];
            for (int i = 0; i < paths.length - 1; ++i) {
                subPath[i] = paths[i + 1];
            }
            return Paths.get(paths[0], subPath).toString();
        }
        return Paths.get(PathExtension.getApplicationPath(), paths).toString();
    }

    public static boolean IsAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static void setApplicationPath(String path) {
        if (!StringExtension.IsNullOrEmpty(path)) {
            applicationPath = path;
        }
    }

    public static synchronized String getApplicationPath() {
        if (StringExtension.IsNullOrEmpty(applicationPath)) {
            Debugger.LogFactory.trace("Getting application path");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null || classLoader.getResource("") == null) {
                applicationPath = System.getProperty("user.dir");
                Debugger.LogFactory.trace("Can't find getEnclosingClass, use user.dir");
            } else {
                String webInfPath;
                String appPath = new File(classLoader.getResource("").getPath()).getPath();
                if (appPath.endsWith(webInfPath = System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator") + "classes")) {
                    Debugger.LogFactory.trace("Use WEB-INF Path");
                    applicationPath = StringExtension.TrimEnd(appPath, webInfPath);
                } else {
                    applicationPath = System.getProperty("user.dir");
                }
            }
            Debugger.LogFactory.trace(applicationPath);
        }
        return applicationPath;
    }

    public static String getConfigFilePath(String filePath) {
        return PathExtension.FullPhysicalPath(Paths.get(Config.ConfigFolder, filePath).toString());
    }

    public static OS getOS() {
        if (cachedOS == null) {
            cachedOS = PathExtension.readOS();
            Debugger.LogFactory.trace("OS is " + cachedOS.toString());
        }
        return cachedOS;
    }

    private static OS readOS() {
        String OSName = System.getProperty("os.name").toLowerCase();
        if (OSName.contains(OS.Win.toString().toLowerCase())) {
            return OS.Win;
        }
        if (OSName.contains(OS.Mac.toString().toLowerCase())) {
            return OS.Mac;
        }
        if (OSName.contains(OS.Unix.toString().toLowerCase())) {
            return OS.Unix;
        }
        if (OSName.contains(OS.Solaris.toString().toLowerCase())) {
            return OS.Solaris;
        }
        return OS.Others;
    }

    static {
        cachedOS = null;
    }

    public static enum OS {
        Win,
        Mac,
        Unix,
        Solaris,
        Others;

    }
}

