/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;
import LinkFuture.Init.Extensions.StringExtension;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateExtension {
    public static Date Parse(String dateString) throws ParseException {
        if (StringExtension.IsNumeric(dateString)) {
            return new Date(Long.parseLong(dateString));
        }
        if (dateString.length() == 29) {
            return DateExtension.Parse(dateString, "yyyy/MM/dd'T'HH:mm:ss.SSSXXX");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.parse(dateString);
    }

    public static Date Parse(String dateString, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(dateString);
    }

    public static Date UTCParse(String dateString, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.parse(dateString);
    }

    public static String Format(Date date) throws ParseException {
        return DateExtension.Format(date, "yyyy/MM/dd'T'HH:mm:ss.SSSXXX");
    }

    public static String Format(Date date, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String UTFFormat(Date date, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(Config.UTCTimeZone);
        return formatter.format(date);
    }

    public static String ISO8601UTCFormat(Date date) throws ParseException {
        return DateExtension.UTFFormat(date, "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
    }
}

