/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Init;

import LinkFuture.Init.Debugger;
import java.io.File;
import java.net.URL;
import java.util.TimeZone;
import javax.naming.InitialContext;

public class Config {
    public static final String DefaultTimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSSXXX";
    public static final String ISO8601TimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'";
    public static final TimeZone UTCTimeZone = TimeZone.getTimeZone("UTC");
    public static final String NewLine = System.getProperty("line.separator");
    public static final String DefaultEncoding = "UTF-8";
    public static final String Empty = "";
    public static final String Version = "1.0.3";
    public static final String ApplicationConfigurationFileName = Config.ReadConfigFileName();
    public static final String ConfigFolder = Config.ReadConfigFolder();
    public static int MaxParallelThread = 10;

    private static String ReadConfigFolder() {
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_dir").toString();
        }
        catch (Exception e) {
            File resourceFile;
            Debugger.LogFactory.warn("Can't find Application.Config path at java:/comp/env/LinkFuture/config_dir");
            ClassLoader classLoader = Config.class.getClassLoader();
            URL applicationFile = classLoader.getResource(ApplicationConfigurationFileName);
            if (applicationFile != null && (resourceFile = new File(applicationFile.getFile())).exists()) {
                return resourceFile.getParent().toString();
            }
            Debugger.LogFactory.warn("Can't find Application.Config at resource");
            return "Static/Config";
        }
    }

    private static String ReadConfigFileName() {
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_fileName").toString();
        }
        catch (Exception e) {
            return "Application.Config";
        }
    }
}

