/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.WebClient;

import LinkFuture.Core.WebClient.CredentialInfo;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;

public class GroupAuthenticator
extends Authenticator {
    private static final ConcurrentHashMap<String, String> TicketMemory = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, PasswordAuthentication> DigestMemory = new ConcurrentHashMap();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Debugger.LogFactory.trace("getPasswordAuthentication");
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
            String host = this.getRequestingHost().toLowerCase();
            if (DigestMemory.containsKey(host)) {
                Debugger.LogFactory.trace("get digest ticket for {} host", (Object)host);
                return DigestMemory.get(host);
            }
            Debugger.LogFactory.trace("can't find digest for {} host", (Object)host);
        } else {
            if (this.getRequestingProtocol().equalsIgnoreCase("https") && ConfigurationController.ConfigurationMeta.ProxySettings != null && ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy != null && ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy.Ticket != null) {
                return ConfigurationController.ConfigurationMeta.ProxySettings.HttpsProxy.Ticket;
            }
            if (this.getRequestingProtocol().equalsIgnoreCase("http") && ConfigurationController.ConfigurationMeta.ProxySettings != null && ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy != null && ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy.Ticket != null) {
                return ConfigurationController.ConfigurationMeta.ProxySettings.HttpProxy.Ticket;
            }
        }
        return null;
    }

    public static String RegisterAuthentication(String host, CredentialInfo credential) {
        host = host.toLowerCase();
        switch (credential.RequestAuthType) {
            case Basic: {
                if (TicketMemory.containsKey(host)) break;
                TicketMemory.put(host, "Basic " + DatatypeConverter.printBase64Binary((byte[])(credential.UserName + ":" + credential.Password).getBytes()));
                break;
            }
            case Digest: {
                if (DigestMemory.containsKey(host)) break;
                DigestMemory.put(host, new PasswordAuthentication(credential.UserName, credential.Password.toCharArray()));
            }
        }
        return TicketMemory.get(host);
    }

    public static void SetAuthorizationTicket(String host, String ticket) {
        boolean hasKey = TicketMemory.containsKey(host = host.toLowerCase());
        if (!hasKey || hasKey && !TicketMemory.get(host).equals(ticket)) {
            Debugger.LogFactory.trace("Saving digest ticket for host {}", (Object)host);
            TicketMemory.put(host, ticket);
        }
    }
}

