/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core;

import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameListPair;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public final class UriBuilder {
    private String scheme;
    private String userInfo;
    private String host;
    private int port = 80;
    private String path;
    private CaseInsensitiveMap<NameListPair<String>> query;
    private String fragment;

    private UriBuilder(String scheme, String userInfo, String host, Integer port, String path, String query, String fragment) {
        this.setAll(scheme, userInfo, host, port, path, query, fragment);
    }

    private void setAll(String scheme, String userInfo, String host, Integer port, String path, String query, String fragment) {
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port == null || port == -1 ? 80 : port;
        this.path = path;
        this.query = new CaseInsensitiveMap();
        this.setQuery(query);
        this.fragment = fragment;
    }

    private static void readQuery(CaseInsensitiveMap<NameListPair<String>> map, String query) {
        if (!StringExtension.IsNullOrEmpty(query)) {
            String[] list;
            map.clear();
            for (String item : list = query.split("&")) {
                String[] queryItem = item.split("=");
                String key = queryItem[0];
                String value = "";
                try {
                    value = queryItem.length > 1 ? URLDecoder.decode(queryItem[1], "UTF-8") : "";
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                map.put(key, new NameListPair<String>(key, value));
            }
        }
    }

    public static String writeQuery(CaseInsensitiveMap<NameListPair<String>> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            NameListPair queryList = (NameListPair)entry.getValue();
            for (String item : queryList.values) {
                sb.append(((NameListPair)entry.getValue()).id);
                sb.append("=");
                try {
                    sb.append(URLEncoder.encode(item, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append("");
                }
                sb.append("&");
            }
        }
        return StringExtension.TrimEnd(sb.toString(), "&");
    }

    public static UriBuilder create(String scheme, String userInfo, String host, Integer port, String path, String query, String fragment) {
        return new UriBuilder(scheme, userInfo, host, port, path, query, fragment);
    }

    public static UriBuilder create(URI uri) {
        return UriBuilder.create(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
    }

    public static UriBuilder create(String uri) {
        return UriBuilder.create(URI.create(uri));
    }

    public static UriBuilder create() {
        return UriBuilder.create(null, null, null, null, null, null, null);
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriBuilder setScheme(Object scheme) {
        this.scheme = scheme == null ? null : scheme.toString();
        return this;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public UriBuilder setUserInfo(Object userInfo) {
        this.userInfo = userInfo == null ? null : userInfo.toString();
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UriBuilder setHost(Object host) {
        this.host = host == null ? null : host.toString();
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UriBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UriBuilder setPath(Object path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public String getQuery() {
        return UriBuilder.writeQuery(this.query);
    }

    public List<String> getQuery(String key) {
        return this.query.get((String)key).values;
    }

    public UriBuilder setQuery(String query) {
        UriBuilder.readQuery(this.query, query);
        return this;
    }

    public UriBuilder setQuery(String key, String value) {
        this.query.put(key, new NameListPair<String>(key, value));
        return this;
    }

    public UriBuilder addQuery(String key, String value) {
        if (this.hasQuery(key)) {
            this.query.get((String)key).values.add(value);
        } else {
            this.query.put(key, new NameListPair<String>(key, value));
        }
        return this;
    }

    public boolean hasQuery(String key) {
        return this.query.containsKey(key);
    }

    public NameListPair<String> removeQuery(String key) {
        if (this.hasQuery(key)) {
            this.query.remove(key);
        }
        return null;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder setFragment(Object fragment) {
        this.fragment = fragment == null ? null : fragment.toString();
        return this;
    }

    public URI build() {
        return URI.create(this.toString());
    }

    public UriBuilder parse(String uriString) {
        URI uri = URI.create(uriString);
        this.setAll(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
        return this;
    }

    public String toString() {
        String queryList = this.getQuery();
        int len = this.len(this.scheme, 1) + this.len(this.userInfo, 2) + this.len(this.host, 2) + 6 + this.len(this.path, 1) + this.len(queryList, 1) + this.len(this.fragment, 1);
        StringBuilder sb = new StringBuilder(len);
        if (!StringExtension.IsNullOrEmpty(this.scheme)) {
            sb.append(this.scheme).append(":");
        }
        if (!StringExtension.IsNullOrEmpty(this.userInfo) || !StringExtension.IsNullOrEmpty(this.host)) {
            sb.append("//");
        }
        if (!StringExtension.IsNullOrEmpty(this.userInfo)) {
            sb.append(this.userInfo);
            sb.append("@");
        }
        if (!StringExtension.IsNullOrEmpty(this.host)) {
            sb.append(this.host);
        }
        if (this.port != 80) {
            sb.append(":");
            sb.append(this.port);
        }
        if (!StringExtension.IsNullOrEmpty(this.path)) {
            if (sb.length() > 0 && !this.path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this.path);
        }
        if (!StringExtension.IsNullOrEmpty(queryList)) {
            sb.append("?");
            sb.append(this.getQuery());
        }
        if (!StringExtension.IsNullOrEmpty(this.fragment)) {
            sb.append("#");
            sb.append(this.fragment);
        }
        return sb.toString();
    }

    private int len(String s, int extra) {
        return s == null ? 0 : s.length() + extra;
    }
}

