/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.OperationManager;

import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class OperationController {
    public static Object runWithRetry(int maxAttempts, Operation operation) {
        for (int count = 0; count < maxAttempts; ++count) {
            try {
                return operation.call();
            }
            catch (Exception e) {
                operation.handleException(e);
                continue;
            }
        }
        return null;
    }

    public static Object runWithRetryThrowException(int maxAttempts, Operation operation, boolean throwException) throws Exception {
        Exception ex = null;
        for (int count = 0; count < maxAttempts; ++count) {
            try {
                return operation.call();
            }
            catch (Exception e) {
                operation.handleException(e);
                ex = e;
                continue;
            }
        }
        if (throwException && ex != null) {
            throw ex;
        }
        return null;
    }

    public static Object run(Operation operation) throws Exception {
        return operation.call();
    }

    public static <T> List<T> runInParallel(List<Operation<T>> tasks, int maxThread) throws InterruptedException, ExecutionException {
        ExecutorService taskExecutor = Executors.newFixedThreadPool(maxThread);
        List<Future<T>> results = taskExecutor.invokeAll(tasks);
        taskExecutor.shutdown();
        ArrayList<T> output = new ArrayList<T>();
        for (Future<T> item : results) {
            if (!item.isDone()) continue;
            output.add(item.get());
        }
        return output;
    }

    public static <T> List<T> runInParallel(List<Operation<T>> tasks) throws InterruptedException, ExecutionException {
        return OperationController.runInParallel(tasks, Config.MaxParallelThread);
    }
}

