/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.JsonManager;

import LinkFuture.Core.JsonManager.JsonObjectType;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.JsonManager.JsonValueType;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class JsonObjectInfo {
    public String XPath;
    public String Name;
    public String Value;
    public JsonObjectType Type;
    public ArrayList<JsonObjectInfo> ChildNodes;
    public JsonObjectInfo Parent;

    public void getJsonValue(StringWriter writer, JsonOptionInfo option) throws IOException {
        String string = this.Value;
        if (StringExtension.IsNullOrEmpty(string)) {
            writer.write("null");
            return;
        }
        if (option.AutoNull && string.equalsIgnoreCase("null")) {
            writer.write("null");
            return;
        }
        switch (option.ValueOption) {
            case Auto: {
                if (this.parseJsonBoolean(writer, string)) {
                    return;
                }
                if (!this.parseJsonNumber(writer, string)) break;
                return;
            }
            case AllString: {
                break;
            }
            case Force: {
                if (option.ForceValueTypeList == null || !option.ForceValueTypeList.containsKey(this.XPath)) break;
                JsonValueType valueType = option.ForceValueTypeList.get((String)this.XPath).ValueType;
                switch (valueType) {
                    case String: {
                        StringExtension.JsonQuote(string, writer);
                        return;
                    }
                    case Number: {
                        if (this.parseJsonNumber(writer, string)) {
                            return;
                        }
                        throw new IllegalArgumentException(String.format("the value(%s) not match the type(Number) you force declared", string));
                    }
                    case Boolean: {
                        if (this.parseJsonBoolean(writer, string)) {
                            return;
                        }
                        throw new IllegalArgumentException(String.format("the value(%s) not match the type(Boolean) you force declared", string));
                    }
                }
            }
        }
        StringExtension.JsonQuote(string, writer);
    }

    private boolean parseJsonBoolean(StringWriter writer, String string) {
        if (string.equalsIgnoreCase("true")) {
            writer.write("true");
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            writer.write("false");
            return true;
        }
        return false;
    }

    private boolean parseJsonNumber(StringWriter writer, String string) {
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        writer.write(d.toString());
                        return true;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        writer.write(myLong.toString());
                        return true;
                    }
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return false;
    }

    public String toJson() {
        return this.toJson(new JsonOptionInfo());
    }

    public String toJson(JsonOptionInfo option) {
        StringWriter writer = new StringWriter();
        writer.append('{');
        this.toJson(writer, option);
        writer.append('}');
        return writer.toString();
    }

    public void toJson(StringWriter writer, JsonOptionInfo option) {
        try {
            StringExtension.JsonQuote(this.getJsonNodeName(option), writer);
            writer.append(':');
            this.toChildJson(writer, option);
        }
        catch (IOException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    public String getJsonNodeName(JsonOptionInfo option) {
        String[] index;
        String nodeName = this.Name;
        if (option.IgnoreNamespace && (index = this.Name.split(":")).length == 2) {
            nodeName = index[1];
        }
        if (option != null) {
            switch (this.Type) {
                case Element: {
                    return nodeName;
                }
                case Attribute: {
                    return option.AttributePrefix + nodeName;
                }
                case Namespace: {
                    return option.NamespacePrefix + nodeName;
                }
                case CDATA: {
                    return option.CDataNodeName;
                }
            }
        }
        return nodeName;
    }

    public String toChildJson(JsonOptionInfo option) throws IOException {
        StringWriter w = new StringWriter();
        this.toChildJson(w, option);
        return w.toString();
    }

    public void toChildJson(StringWriter writer, JsonOptionInfo option) throws IOException {
        if (this.ChildNodes == null || this.ChildNodes.size() == 0) {
            this.getJsonValue(writer, option);
        } else {
            LinkedHashMap<String, ArrayList> nameList = new LinkedHashMap<String, ArrayList>();
            for (JsonObjectInfo item : this.ChildNodes) {
                if (item.Type == JsonObjectType.Namespace && option.IgnoreNamespace) continue;
                ArrayList list = nameList.containsKey(item.Name) ? (ArrayList)nameList.get(item.Name) : new ArrayList();
                list.add(item);
                nameList.put(item.Name, list);
            }
            writer.append('{');
            if (!StringExtension.IsNullOrEmpty(this.Value)) {
                writer.write(this.getJsonNodeName(option));
                writer.write(58);
                this.getJsonValue(writer, option);
                writer.write(44);
            }
            String[] key = nameList.keySet().toArray(new String[nameList.keySet().size()]);
            for (int i = 0; i < nameList.keySet().size(); ++i) {
                String nodeKey = key[i];
                ArrayList subList = (ArrayList)nameList.get(nodeKey);
                if (subList.size() == 1 && !this.forceArrayXPath(option, ((JsonObjectInfo)subList.get((int)0)).XPath)) {
                    ((JsonObjectInfo)subList.get(0)).toJson(writer, option);
                } else {
                    StringExtension.JsonQuote(((JsonObjectInfo)subList.get(0)).getJsonNodeName(option), writer);
                    writer.append(':');
                    writer.append('[');
                    for (int j = 0; j < subList.size(); ++j) {
                        JsonObjectInfo item = (JsonObjectInfo)subList.get(j);
                        item.toChildJson(writer, option);
                        if (j >= subList.size() - 1) continue;
                        writer.write(44);
                    }
                    writer.append(']');
                }
                if (i >= key.length - 1) continue;
                writer.write(44);
            }
            writer.append('}');
        }
    }

    public boolean forceArrayXPath(JsonOptionInfo option, String currentXPath) {
        if (option.AllArray) {
            return true;
        }
        if (option == null || option.ForceArrayXPathList == null || option.ForceArrayXPathList.size() == 0) {
            return false;
        }
        return option.ForceArrayXPathList.contains(currentXPath);
    }
}

