/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.JsonManager;

import LinkFuture.Core.JsonManager.JsonObjectInfo;
import LinkFuture.Core.JsonManager.JsonObjectReader;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.JsonManager.JsonValueOption;
import org.json.JSONObject;
import org.json.XML;

public class JsonController {
    public static String convertJsonToXml(String jsonString) {
        JSONObject jsonObject = new JSONObject(jsonString);
        return XML.toString((Object)jsonObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String convertXmlToJson(String xmlString, JsonOptionInfo option) {
        try (JsonObjectReader reader = new JsonObjectReader(xmlString);){
            JsonObjectInfo root = reader.toJsonObj();
            if (option.IgnoreRoot) {
                String string = root.toChildJson(option);
                return string;
            }
            String string = root.toJson(option);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertXmlToJson(String xmlString) {
        JsonOptionInfo option = new JsonOptionInfo();
        option.AttributePrefix = "";
        option.NamespacePrefix = "";
        option.IgnoreNamespace = true;
        option.IgnoreRoot = false;
        option.CDataNodeName = "Content";
        option.ValueOption = JsonValueOption.AllString;
        return JsonController.convertXmlToJson(xmlString, option);
    }
}

