/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.DBBeanReader;
import LinkFuture.Core.DBHelper.DBXmlReader;
import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.DBColumnAttribute;
import LinkFuture.Core.DBHelper.Model.DBConnectionInfo;
import LinkFuture.Core.DBHelper.Model.FieldInfo;
import LinkFuture.Core.DBHelper.Model.IgnoreDBColumnAttribute;
import LinkFuture.Core.DBHelper.Model.ParameterTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.DateExtension;
import LinkFuture.Init.Extensions.StringExtension;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;

public class DBHelper
implements AutoCloseable {
    private Connection conn;
    private static final Map<String, SPInfo> CachedSPMeta = new ConcurrentHashMap<String, SPInfo>();
    public Map<String, SPParameterInfo> inputParameterList = new LinkedHashMap<String, SPParameterInfo>();
    public String dbUrl;
    public SPInfo SPMetaInfo = null;
    public Boolean IsMicrosoftSQLServer = false;
    public Statement statement;
    private boolean autoClose = true;

    public static Connection getConnection(String connectionString) throws SQLException, NamingException, ClassNotFoundException {
        Debugger.LogFactory.trace("Connect to {} ", (Object)connectionString);
        if (connectionString.startsWith("java:/")) {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup(connectionString);
            return ds.getConnection();
        }
        return DriverManager.getConnection(connectionString);
    }

    public DBHelper(Connection conn) throws SQLException, ClassNotFoundException {
        this.autoClose = false;
        this.init(conn);
    }

    public DBHelper(String connectionString) throws IOException, SQLException, ClassNotFoundException, NamingException {
        this.init(DBHelper.getConnection(connectionString));
    }

    private void init(Connection conn) throws SQLException {
        this.conn = conn;
        this.dbUrl = DBConnectionInfo.Parser((String)conn.getMetaData().getURL()).Url;
        this.IsMicrosoftSQLServer = this.conn.getMetaData().getDatabaseProductName().equalsIgnoreCase("Microsoft SQL Server");
    }

    public void addParameter(String name, Object value) {
        this.addParameter(name, value, null);
    }

    public void addOutParameter(String name) {
        this.addParameter(name, null, ParameterTypeInfo.procedureColumnOut);
    }

    private void addParameter(String name, Object value, ParameterTypeInfo type) {
        if (type == null) {
            type = ParameterTypeInfo.procedureColumnIn;
        }
        SPParameterInfo parameter = new SPParameterInfo();
        parameter.parameterName = name;
        parameter.parameterValue = value;
        parameter.parameterType = type;
        this.inputParameterList.put(DBHelper.buildParamKey(name), parameter);
    }

    public ArrayList<ArrayList<?>> executeSP(String commandText, Class<?> ... outputType) throws Exception {
        this.setCommand(commandText, CommandTypeInfo.StoredProcedure);
        boolean hadResults = this.Execute(CommandTypeInfo.StoredProcedure);
        if (hadResults) {
            return new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType);
        }
        return null;
    }

    public <T> ArrayList<T> executeSP(String commandText, Class<T> outputType) throws Exception {
        ArrayList<ArrayList<?>> results;
        this.setCommand(commandText, CommandTypeInfo.StoredProcedure);
        boolean hadResults = this.Execute(CommandTypeInfo.StoredProcedure);
        if (hadResults && (results = new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType)).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public String executeToXml(String commandText, CommandTypeInfo commandType) throws SQLException, ParserConfigurationException, IOException, ParseException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.setCommand(commandText, commandType);
        boolean hadResults = this.Execute(commandType);
        if (!hadResults) {
            return null;
        }
        return new DBXmlReader(this.statement, this.SPMetaInfo).Read();
    }

    public ArrayList<ArrayList<?>> executeSQL(String sql, Class<?> ... outputType) throws Exception {
        this.setCommand(sql, CommandTypeInfo.TSQL);
        boolean hadResults = this.Execute(CommandTypeInfo.TSQL);
        if (hadResults) {
            return new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType);
        }
        return null;
    }

    public <T> ArrayList<T> executeSQL(String sql, Class<T> outputType) throws Exception {
        ArrayList<ArrayList<?>> results;
        this.setCommand(sql, CommandTypeInfo.TSQL);
        boolean hadResults = this.Execute(CommandTypeInfo.TSQL);
        if (hadResults && (results = new DBBeanReader(this.statement, this.SPMetaInfo).Read(outputType)).size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public int executeSQL(String sql) throws SQLException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ParseException {
        this.setCommand(sql, CommandTypeInfo.TSQL);
        return this.TSQLExecuteUpdate();
    }

    @Override
    public void close() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
                this.statement = null;
            }
            if (this.autoClose && this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            Debugger.LogFactory.error("Close DB error", (Throwable)e);
        }
    }

    private void setCommand(String commandText, CommandTypeInfo commandType) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.SPMetaInfo = commandType == CommandTypeInfo.StoredProcedure ? this.findSPInfo(commandText) : this.findTSQLInfo(commandText);
    }

    private boolean Execute(CommandTypeInfo commandType) throws SQLException, ParseException {
        switch (commandType) {
            case TSQL: {
                return this.TSQLExecute();
            }
        }
        return this.SPExecute();
    }

    private boolean SPExecute() throws SQLException, ParseException {
        CallableStatement callableStatement = this.conn.prepareCall(this.SPMetaInfo.sqlCall);
        this.statement = callableStatement;
        this.fillParameter(this.SPMetaInfo, callableStatement);
        return callableStatement.execute();
    }

    private boolean TSQLExecute() throws SQLException, ParseException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.SPMetaInfo.sqlCall);
        this.statement = preparedStatement;
        this.fillParameter(this.SPMetaInfo, preparedStatement);
        return preparedStatement.execute();
    }

    private int TSQLExecuteUpdate() throws SQLException, ParseException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.SPMetaInfo.sqlCall);
        this.statement = preparedStatement;
        this.fillParameter(this.SPMetaInfo, preparedStatement);
        return preparedStatement.executeUpdate();
    }

    private void fillParameter(SPInfo spMeta, PreparedStatement stmt) throws SQLException, ParseException {
        if (spMeta.parameterList.size() > 0) {
            boolean indexModel = spMeta.parameterList.get((int)0).parameterName.equalsIgnoreCase("?");
            int length = spMeta.parameterList.size();
            ArrayList<String> keys = new ArrayList<String>(this.inputParameterList.keySet());
            for (int i = 0; i < length; ++i) {
                SPParameterInfo passedParam;
                if (indexModel) {
                    String paramKey = (String)keys.get(i);
                    passedParam = this.inputParameterList.get(DBHelper.buildParamKey(paramKey));
                    stmt.setObject(i + 1, passedParam.parameterValue);
                    continue;
                }
                SPParameterInfo param = spMeta.parameterList.get(i);
                passedParam = this.inputParameterList.get(DBHelper.buildParamKey(param.parameterName));
                stmt.setObject(i + 1, this.buildPassedValue(param.sqlTypes, passedParam.parameterValue), param.sqlTypes);
            }
        }
    }

    private Object buildPassedValue(int sqlTypes, Object passValue) throws ParseException {
        if ((sqlTypes == 93 || sqlTypes == 91) && passValue instanceof String) {
            return DateExtension.Parse((String)passValue);
        }
        return passValue;
    }

    private void fillParameter(SPInfo spMeta, CallableStatement stmt) throws SQLException, ParseException {
        if (spMeta.parameterList.size() > 0) {
            for (SPParameterInfo param : spMeta.parameterList) {
                String paramKey = DBHelper.buildParamKey(param.parameterName);
                String passParamName = param.parameterName;
                if (this.inputParameterList.containsKey(paramKey) && param.parameterType == ParameterTypeInfo.procedureColumnIn) {
                    Object passValue = this.inputParameterList.get((Object)paramKey).parameterValue;
                    stmt.setObject(passParamName, this.buildPassedValue(param.sqlTypes, passValue));
                } else if (param.parameterType == ParameterTypeInfo.procedureColumnIn) {
                    stmt.setNull(passParamName, param.sqlTypes);
                }
                if (param.parameterType != ParameterTypeInfo.procedureColumnOut && param.parameterType != ParameterTypeInfo.procedureColumnInOut && param.parameterType != ParameterTypeInfo.procedureColumnReturn) continue;
                stmt.registerOutParameter(passParamName, param.sqlTypes);
            }
        }
    }

    public SPInfo findSPInfo(String spName) throws SQLException {
        String key = (this.dbUrl + "_" + spName).toLowerCase();
        if (!CachedSPMeta.containsKey(key)) {
            Debugger.LogFactory.trace("Read SP Info:{}", (Object)key);
            SPInfo spMeta = new SPInfo();
            spMeta.dbName = this.dbUrl;
            spMeta.spName = spName;
            DatabaseMetaData dbmd = this.conn.getMetaData();
            ResultSet rs = dbmd.getProcedureColumns(null, null, spName, null);
            while (rs.next()) {
                SPParameterInfo parameter = new SPParameterInfo();
                parameter.parameterName = this.removeMSSQLPre(rs.getString("COLUMN_NAME"));
                parameter.parameterType = ParameterTypeInfo.convert(rs.getInt("COLUMN_TYPE"));
                if (parameter.parameterType == ParameterTypeInfo.procedureColumnReturn) {
                    spMeta.hasReturn = true;
                }
                parameter.sqlTypes = rs.getInt("DATA_TYPE");
                spMeta.parameterList.add(parameter);
            }
            spMeta.sqlCall = this.buildSPCallString(spMeta);
            CachedSPMeta.put(key, spMeta);
        }
        return CachedSPMeta.get(key);
    }

    private String removeMSSQLPre(String paramName) {
        if (this.IsMicrosoftSQLServer.booleanValue() && paramName.startsWith("@")) {
            return paramName.substring(1);
        }
        return paramName;
    }

    private static String buildParamKey(String paramName) {
        if (paramName.startsWith("@") || paramName.startsWith("$")) {
            return paramName.substring(1).toLowerCase();
        }
        return paramName.toLowerCase();
    }

    private String buildSPCallString(SPInfo spMeta) throws SQLException {
        String paramTemplete = "";
        if (spMeta.parameterList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (SPParameterInfo ignored : spMeta.parameterList) {
                if (ignored.parameterType == ParameterTypeInfo.procedureColumnReturn) continue;
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            paramTemplete = sb.toString();
        }
        if (spMeta.hasReturn) {
            return String.format("{? = call %s%s}", spMeta.spName, paramTemplete);
        }
        return String.format("{call %s%s}", spMeta.spName, paramTemplete);
    }

    public SPInfo findTSQLInfo(String commandText) throws SQLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = (this.dbUrl + "_" + commandText).toLowerCase();
        if (!CachedSPMeta.containsKey(key)) {
            SPInfo spMeta = new SPInfo();
            spMeta.dbName = this.dbUrl;
            spMeta.sqlCall = commandText;
            spMeta.spName = "TSQL";
            ArrayList<String> list = DBHelper.findTSQLParameters(commandText);
            if (list.size() > 0) {
                for (String param : list) {
                    String paramName;
                    SPParameterInfo parameter = new SPParameterInfo();
                    String[] paramMeta = param.split("\\|");
                    parameter.parameterName = paramName = paramMeta[0];
                    parameter.parameterType = ParameterTypeInfo.procedureColumnIn;
                    parameter.sqlTypes = paramMeta.length > 1 ? Integer.parseInt(paramMeta[1]) : 12;
                    spMeta.parameterList.add(parameter);
                    spMeta.sqlCall = spMeta.sqlCall.replace("$" + param, "?");
                }
            } else {
                PreparedStatement preparedStatement = this.conn.prepareStatement(spMeta.sqlCall);
                ParameterMetaData metaList = preparedStatement.getParameterMetaData();
                for (int i = 1; i <= metaList.getParameterCount(); ++i) {
                    SPParameterInfo parameter = new SPParameterInfo();
                    parameter.parameterName = "?";
                    parameter.parameterType = ParameterTypeInfo.procedureColumnIn;
                    parameter.sqlTypes = metaList.getParameterType(i);
                    spMeta.parameterList.add(parameter);
                }
            }
            CachedSPMeta.put(key, spMeta);
        }
        return CachedSPMeta.get(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized SPInfo findSPMetaInfo(String connectionString, String spName, CommandTypeInfo commandType) throws SQLException, ClassNotFoundException, IOException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = ("findSPMetaInfo_" + connectionString + "_" + spName).toLowerCase();
        if (CachedSPMeta.containsKey(key)) return CachedSPMeta.get(key);
        try (DBHelper helper = new DBHelper(connectionString);){
            switch (commandType) {
                case TSQL: {
                    CachedSPMeta.put(key, helper.findTSQLInfo(spName));
                    return CachedSPMeta.get(key);
                }
                case StoredProcedure: {
                    CachedSPMeta.put(key, helper.findSPInfo(spName));
                    return CachedSPMeta.get(key);
                }
            }
            return CachedSPMeta.get(key);
        }
    }

    public static ArrayList<String> findTSQLParameters(String content) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Pattern pattern = Pattern.compile("(\\$[^\",;\\) ]*)", 2);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String param = matcher.group();
            list.add(param.substring(1));
        }
        return list;
    }

    public static TableInfo findResultsColumnInfo(ResultSetMetaData rsMeta) throws SQLException {
        int numberOfColumns = rsMeta.getColumnCount();
        TableInfo tableMeta = new TableInfo();
        for (int i = 1; i <= numberOfColumns; ++i) {
            ColumnInfo columnMeta = new ColumnInfo();
            String label = rsMeta.getColumnLabel(i);
            columnMeta.columnName = StringExtension.IsNullOrEmpty(label) ? rsMeta.getColumnName(i) : label;
            columnMeta.javaClassName = rsMeta.getColumnClassName(i);
            columnMeta.sqlTypeName = rsMeta.getColumnTypeName(i);
            columnMeta.sqlType = rsMeta.getColumnType(i);
            tableMeta.columnList.add(columnMeta);
        }
        return tableMeta;
    }

    public static synchronized HashMap<String, FieldInfo> findClassFieldInfo(Class<?> type) throws Exception {
        String classKey = "$DBHelper$FindClassFieldInfo".concat(type.getName());
        return (HashMap)StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(classKey, new Operation<HashMap<String, FieldInfo>>(new Object[]{type}){

            @Override
            public HashMap<String, FieldInfo> call() throws Exception {
                HashMap<String, FieldInfo> fieldList = new HashMap<String, FieldInfo>();
                Class runType = (Class)this.params[0];
                Debugger.LogFactory.trace(runType.getName());
                for (Field field : runType.getDeclaredFields()) {
                    IgnoreDBColumnAttribute ignoreAttribute = field.getAnnotation(IgnoreDBColumnAttribute.class);
                    if (ignoreAttribute != null) continue;
                    DBColumnAttribute columnAttribute = field.getAnnotation(DBColumnAttribute.class);
                    FieldInfo fieldMeta = new FieldInfo();
                    fieldMeta.field = field;
                    if (columnAttribute != null) {
                        String columnName;
                        String string = columnName = columnAttribute.columnName().length() == 0 ? field.getName() : columnAttribute.columnName();
                        if (columnAttribute.isEntity()) {
                            DBHelper.findClassFieldInfo(field.getType());
                        }
                        fieldMeta.columnAttribute = columnAttribute;
                        fieldList.put(columnName.toLowerCase(), fieldMeta);
                        continue;
                    }
                    fieldList.put(field.getName().toLowerCase(), fieldMeta);
                }
                return fieldList;
            }
        });
    }

    public static Map<String, Object> ReadOutputParameterList(SPInfo spMetaInfo, CallableStatement callableStatement) throws SQLException {
        HashMap<String, Object> outputParameterList = new HashMap<String, Object>();
        if (spMetaInfo.parameterList != null && spMetaInfo.parameterList.size() > 0) {
            for (SPParameterInfo param : spMetaInfo.parameterList) {
                if (param.parameterType != ParameterTypeInfo.procedureColumnOut && param.parameterType != ParameterTypeInfo.procedureColumnInOut && param.parameterType != ParameterTypeInfo.procedureColumnReturn) continue;
                outputParameterList.put(DBHelper.buildParamKey(param.parameterName), callableStatement.getObject(param.parameterName));
            }
        }
        return outputParameterList;
    }

    public Map<String, Object> getOutputParameterList() throws SQLException {
        return DBHelper.ReadOutputParameterList(this.SPMetaInfo, (CallableStatement)this.statement);
    }
}

