/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public class ContentResultCollectionInfo
extends CaseInsensitiveMap<ContentResultInfo> {
    public ContentParameterCollectionInfo Params;

    public String ToContentXml() {
        StringBuilder sb = new StringBuilder();
        if (this.size() > 1) {
            sb.append("<Root>");
        }
        for (Map.Entry item : this.entrySet()) {
            ContentResultInfo result = (ContentResultInfo)item.getValue();
            if (this.size() > 1) {
                sb.append("<Content");
                sb.append(" name=\"");
                sb.append((String)item.getKey());
                sb.append("\"");
                sb.append(" success=\"");
                sb.append(result.Success);
                sb.append("\"");
                sb.append(">");
            }
            Object value = result.Result;
            if (result.Success && value != null) {
                if (value instanceof String) {
                    switch (result.ResultType) {
                        case Json: {
                            value = "<Root>".concat(JsonController.convertJsonToXml((String)value)).concat("</Root>");
                            break;
                        }
                        case Binary: {
                            value = "";
                        }
                    }
                    sb.append(Utility.removeXmlDeclaration((String)value));
                } else {
                    sb.append(Utility.removeXmlDeclaration(Utility.toXml(value)));
                }
            }
            if (this.size() <= 1) continue;
            sb.append("</Content>");
        }
        if (this.size() > 1) {
            sb.append("</Root>");
        }
        return sb.toString();
    }

    public String ToResourceOnlyXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Root>");
        for (Map.Entry item : this.entrySet()) {
            ContentResultInfo result = (ContentResultInfo)item.getValue();
            sb.append("<Content");
            sb.append(" name=\"");
            sb.append((String)item.getKey());
            sb.append("\"");
            sb.append(" success=\"");
            sb.append(result.Success);
            sb.append("\"");
            sb.append(" code=\"");
            sb.append(result.ErrorCode);
            sb.append("\"");
            sb.append(" loadTimeMs=\"");
            sb.append(result.LoadTimeInMs);
            sb.append("\"");
            if (result.Meta != null) {
                sb.append(" meta=\"");
                sb.append(StringExtension.XmlEscape(result.Meta));
                sb.append("\"");
            }
            sb.append(">");
            Object value = result.Result;
            if (result.Success && value != null) {
                if (value instanceof String) {
                    switch (result.ResultType) {
                        case Json: {
                            value = "<Root>".concat(JsonController.convertJsonToXml((String)value)).concat("</Root>");
                            break;
                        }
                        case Binary: {
                            value = "";
                        }
                    }
                    sb.append(Utility.removeXmlDeclaration((String)value));
                } else {
                    sb.append(Utility.removeXmlDeclaration(Utility.toXml(value)));
                }
            } else {
                sb.append("<ErrorMessage>");
                sb.append(StringExtension.XmlEscape(Debugger.getDetail(result.Error)));
                sb.append("</ErrorMessage>");
            }
            sb.append("</Content>");
        }
        sb.append("</Root>");
        return sb.toString();
    }

    public String ToContentJson() throws IOException {
        if (this.size() == 1) {
            ContentResultInfo result = (ContentResultInfo)this.values().toArray()[0];
            return this.GenerateJson(result);
        }
        StringWriter sb = new StringWriter();
        int index = 0;
        sb.append("{");
        sb.append("\"Root\":");
        sb.append("{\"Content\":[");
        for (Map.Entry item : this.entrySet()) {
            ContentResultInfo result = (ContentResultInfo)item.getValue();
            sb.append("{");
            sb.append("\"name\":");
            StringExtension.JsonQuote((String)item.getKey(), sb);
            sb.append(",\"success\":");
            StringExtension.JsonQuote(String.valueOf(result.Success), sb);
            if (result.Success && result.Result != null) {
                sb.append(",\"response\":");
                sb.append(this.GenerateJson(result));
            }
            sb.append("}");
            if (++index == this.size()) continue;
            sb.append(",");
        }
        sb.append("]}");
        sb.append("}");
        return sb.toString();
    }

    public String ToResourceOnlyJson() throws IOException {
        StringWriter sb = new StringWriter();
        int index = 0;
        if (this.size() > 1) {
            sb.append("{");
            sb.append("\"Root\":");
            sb.append("{\"Content\":[");
        }
        for (Map.Entry item : this.entrySet()) {
            ContentResultInfo result = (ContentResultInfo)item.getValue();
            sb.append("{");
            sb.append("\"name\":");
            StringExtension.JsonQuote((String)item.getKey(), sb);
            sb.append(",\"success\":");
            StringExtension.JsonQuote(String.valueOf(result.Success), sb);
            sb.append(",\"code\":");
            StringExtension.JsonQuote(String.valueOf(result.ErrorCode), sb);
            sb.append(",\"loadTimeMs\":");
            StringExtension.JsonQuote(String.valueOf(result.LoadTimeInMs), sb);
            if (result.Meta != null) {
                sb.append(",\"meta\":");
                StringExtension.JsonQuote(result.Meta, sb);
            }
            if (result.Success && result.Result != null) {
                sb.append(",\"response\":");
                sb.append(this.GenerateJson(result));
            } else {
                sb.append("\"errorMessage\":");
                StringExtension.JsonQuote(Debugger.getDetail(result.Error), sb);
            }
            sb.append("}");
            if (++index == this.size()) continue;
            sb.append(",");
        }
        if (this.size() > 1) {
            sb.append("]}");
            sb.append("}");
        }
        return sb.toString();
    }

    private String GenerateJson(ContentResultInfo result) {
        Object value = result.Result;
        if (value instanceof String) {
            switch (result.ResultType) {
                case Xml: {
                    value = JsonController.convertXmlToJson((String)value);
                    break;
                }
                case Binary: {
                    value = "";
                }
            }
        } else {
            value = Utility.toJson(value);
        }
        return (String)value;
    }

    private String RemoveJsonHeader(String jsonString) {
        return StringExtension.TrimEnd(StringExtension.TrimStart(jsonString.trim(), "{"), "}");
    }
}

