/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentValidator;

import LinkFuture.Core.ContentManager.ContentValidator.ContentBeanBaseValidator;
import LinkFuture.Core.ContentManager.ContentValidator.InputParameterListMetaInfo;
import LinkFuture.Core.ContentManager.ContentValidator.InputParameterMetaInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Init.Extensions.StringExtension;
import java.util.regex.Pattern;

public class InputParameterValidator
extends ContentBeanBaseValidator<InputParameterListMetaInfo> {
    public InputParameterValidator(ContentItemInfo content, ValidatorInfo CurrentValidator) throws Exception {
        super(content, CurrentValidator, InputParameterListMetaInfo.class);
    }

    @Override
    public void Valid(ContentParameterCollectionInfo parameters) {
        if (((InputParameterListMetaInfo)this.Meta).ParameterList != null && ((InputParameterListMetaInfo)this.Meta).ParameterList.size() > 0) {
            if (parameters == null) {
                throw new IllegalArgumentException("Parameter required");
            }
            for (InputParameterMetaInfo inputParameter : ((InputParameterListMetaInfo)this.Meta).ParameterList) {
                if (parameters.containsKey(inputParameter.Name)) {
                    Pattern p;
                    String inputValue = parameters.get(inputParameter.Name).toString();
                    if (StringExtension.IsNullOrEmpty(inputValue) && inputParameter.IsRequired) {
                        throw new IllegalArgumentException(String.format("%s is required", inputParameter.Name));
                    }
                    if (StringExtension.IsNullOrEmpty(inputParameter.Validation) || (p = Pattern.compile(inputParameter.Validation, 2)).matcher(inputValue).matches()) continue;
                    this.throwException(inputParameter);
                    continue;
                }
                if (!StringExtension.IsNullOrEmpty(inputParameter.DefaultValue)) {
                    parameters.put(inputParameter.Name, inputParameter.DefaultValue);
                    continue;
                }
                if (!inputParameter.IsRequired) continue;
                throw new IllegalArgumentException(String.format("%s is required", inputParameter.Name));
            }
        }
    }

    private void throwException(InputParameterMetaInfo inputParameter) {
        throw new IllegalArgumentException(StringExtension.IsNullOrEmpty(inputParameter.ErrorMessage) ? inputParameter.Name : inputParameter.ErrorMessage);
    }
}

