/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.AddParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

public class ContentSelectorController {
    public static void BuilderSelector(AddInfo add, ContentParameterCollectionInfo parameters, AddCycleType cycleType) throws Exception {
        if (add != null && add.SelectorList != null && add.SelectorList.size() > 0) {
            for (AddParameterInfo item : add.SelectorList.values()) {
                String itemKey;
                if (item.Cycle != cycleType) break;
                String string = itemKey = StringExtension.IsNullOrEmpty(item.OutName) ? item.Name : item.OutName;
                if (StringExtension.IsNullOrEmpty(item.Value)) {
                    if (!StringExtension.IsNullOrEmpty(item.DefaultValue)) {
                        Debugger.LogFactory.trace("Get selector default value {} => {}", (Object)itemKey, (Object)item.DefaultValue);
                        parameters.put(itemKey, item.DefaultValue);
                        continue;
                    }
                    if (item.IgnoreException) continue;
                    throw new IllegalArgumentException("Can't find value for selector:" + item.Name);
                }
                String[] keyList = StringExtension.FindReplacement(item.Value);
                String itemValue = item.Value;
                if (keyList != null) {
                    for (int i = 0; i < keyList.length; ++i) {
                        String key = keyList[i];
                        Object replacement = null;
                        replacement = parameters.containsKey(key) ? (Object)parameters.get(key) : parameters.getSelector("{".concat(key).concat("}"));
                        if (replacement != null && !StringExtension.IsNullOrEmpty(replacement.toString())) {
                            itemValue = StringExtension.ReplaceAll(itemValue, key, replacement.toString());
                            continue;
                        }
                        if (!item.IgnoreException) {
                            throw new IllegalArgumentException(String.format("Can't find specific param(%s) for selector %s,", key, item.Name));
                        }
                        itemValue = StringExtension.ReplaceAll(itemValue, key, "");
                    }
                }
                Debugger.LogFactory.trace("Get selector value {} => {}", (Object)itemKey, (Object)itemValue);
                parameters.put(item.Name, itemValue);
            }
        }
    }
}

