/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentSelector;

import LinkFuture.Core.ContentManager.ContentSelector.ContentSelectorMeta;
import LinkFuture.Core.ContentManager.ContentSelector.IContentSelector;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ContentBaseSelector
implements IContentSelector {
    protected CaseInsensitiveMap<Object> currentParameters;
    protected ContentSelectorMeta meta;
    private String resourceIdentity;
    private ConcurrentHashMap<String, Object> cachedObject = new ConcurrentHashMap();

    public ContentBaseSelector(ContentParameterCollectionInfo parameters, ContentSelectorMeta meta) {
        this.currentParameters = parameters;
        this.meta = meta;
    }

    @Override
    public Object Selector() throws Exception {
        String key = this.GetSelectorIdentity();
        if (!this.cachedObject.containsKey(key)) {
            Object result = this.LoadSelector();
            if (result != null) {
                Debugger.LogFactory.trace("Selector {} => {}", (Object)key, result);
                this.cachedObject.put(key, result);
            } else {
                return null;
            }
        }
        return this.cachedObject.get(key);
    }

    public abstract Object LoadSelector() throws Exception;

    @Override
    public String GetSelectorIdentity() throws Exception {
        if (StringExtension.IsNullOrEmpty(this.resourceIdentity)) {
            this.resourceIdentity = this.BuildSelectorIdentity().toLowerCase();
        }
        return this.resourceIdentity;
    }

    public abstract String BuildSelectorIdentity() throws Exception;
}

