/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.ContentResource.ContentBeanBaseResource;
import LinkFuture.Core.ContentManager.ContentResource.WebContentResourceMetaInfo;
import LinkFuture.Core.ContentManager.ContentResource.WebContentResourceParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.UriBuilder;
import LinkFuture.Core.WebClient.CredentialInfo;
import LinkFuture.Core.WebClient.HttpMethod;
import LinkFuture.Core.WebClient.WebClient;
import LinkFuture.Core.WebClient.WebClientResultInfo;
import LinkFuture.Core.WebClient.WebRequestFileInfo;
import LinkFuture.Core.WebClient.WebRequestInfo;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.Utility;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WebContentResource
extends ContentBeanBaseResource<WebContentResourceMetaInfo> {
    static final String ContentType = "Content-Type";
    public String ResourceUrl;

    public WebContentResource(ResourceInfo currentResource) throws Exception {
        super(currentResource, WebContentResourceMetaInfo.class);
        if (((WebContentResourceMetaInfo)this.Meta).ContentType == null) {
            ((WebContentResourceMetaInfo)this.Meta).ContentType = ContentResultType.Xml;
        }
    }

    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        this.ResourceUrl = this.BuildAbsoluteUri(parameters, true);
        if (StringExtension.HasReplacement(this.ResourceUrl)) {
            throw new IllegalArgumentException("Specific url is incorrect:" + this.ResourceUrl);
        }
        ContentResultInfo contentResult = new ContentResultInfo();
        if (StringExtension.IsUrl(this.ResourceUrl)) {
            contentResult.Meta = this.ResourceUrl;
            ArrayList<NameValuePair> postList = this.BuildPostArguments(parameters, true);
            ArrayList<NameValuePair> headList = this.BuildHeadArguments(parameters, true);
            WebRequestInfo meta = new WebRequestInfo();
            meta.RequestURL = new URL(this.ResourceUrl);
            meta.RequestMethod = ((WebContentResourceMetaInfo)this.Meta).Method;
            if (((WebContentResourceMetaInfo)this.Meta).AuthType != null) {
                meta.Credential = new CredentialInfo(((WebContentResourceMetaInfo)this.Meta).AuthType, parameters.ParamReplace(((WebContentResourceMetaInfo)this.Meta).UserName), parameters.ParamReplace(((WebContentResourceMetaInfo)this.Meta).Password));
            }
            for (NameValuePair item : postList) {
                if (item.value instanceof WebRequestFileInfo) {
                    meta.addPostFile((WebRequestFileInfo)item.value);
                    continue;
                }
                meta.addPostData(item.id, item.value);
            }
            for (NameValuePair item : headList) {
                meta.addHead(item.id, item.value);
            }
            if (!StringExtension.IsNullOrEmpty(((WebContentResourceMetaInfo)this.Meta).Payload)) {
                meta.addPayload(parameters.ParamReplace(((WebContentResourceMetaInfo)this.Meta).Payload));
            }
            meta.ConnectionTimeout = ((WebContentResourceMetaInfo)this.Meta).ConnectionTimeout;
            meta.ReadTimeout = ((WebContentResourceMetaInfo)this.Meta).ReadTimeout;
            if (((WebContentResourceMetaInfo)this.Meta).UseCaches != null) {
                meta.UseCaches = ((WebContentResourceMetaInfo)this.Meta).UseCaches;
            }
            if (((WebContentResourceMetaInfo)this.Meta).AutoRedirect != null) {
                meta.AutoRedirect = ((WebContentResourceMetaInfo)this.Meta).AutoRedirect;
            }
            WebClientResultInfo result = WebClient.sendRequest(meta, ((WebContentResourceMetaInfo)this.Meta).RetryTimes);
            contentResult.ErrorCode = result.code;
            if (result.success) {
                contentResult.Success = true;
                contentResult.ResultType = this.getContentResultType(result);
                contentResult.Result = result.response;
            } else {
                contentResult.Result = result.response;
                contentResult.Success = false;
                contentResult.Error = new IOException(result.errorMessage);
            }
        } else {
            contentResult.Meta = this.ResourceUrl = PathExtension.FullPhysicalPath(this.ResourceUrl);
            contentResult.Success = true;
            contentResult.ErrorCode = 500;
            contentResult.Result = Utility.getStringFromFile(this.ResourceUrl);
            contentResult.ErrorCode = 200;
            contentResult.ResultType = ((WebContentResourceMetaInfo)this.Meta).ContentType;
        }
        return contentResult;
    }

    private ContentResultType getContentResultType(WebClientResultInfo result) {
        if (result.HeaderFields.containsKey(ContentType)) {
            String contentType = result.HeaderFields.get(ContentType).toLowerCase();
            if (contentType.contains("json")) {
                return ContentResultType.Json;
            }
            if (contentType.contains("xml")) {
                return ContentResultType.Xml;
            }
            if (contentType.contains("image") || contentType.contains("audio")) {
                return ContentResultType.Binary;
            }
            if (contentType.contains("text")) {
                return ContentResultType.Text;
            }
        }
        return ((WebContentResourceMetaInfo)this.Meta).ContentType;
    }

    private String BuildAbsoluteUri(ContentParameterCollectionInfo parameters, boolean throwException) {
        String targetUri = ((WebContentResourceMetaInfo)this.Meta).FeedUri;
        if (parameters != null) {
            targetUri = parameters.ParamReplace(targetUri);
        }
        if (((WebContentResourceMetaInfo)this.Meta).UrlParameters != null) {
            UriBuilder uriBuilder = UriBuilder.create(targetUri);
            ArrayList<NameValuePair> list = this.BuildUrlArguments(parameters, throwException);
            for (NameValuePair item : list) {
                uriBuilder.setQuery(item.id, item.value.toString());
            }
            targetUri = uriBuilder.toString();
        }
        return targetUri;
    }

    private ArrayList<NameValuePair> BuildHeadArguments(ContentParameterCollectionInfo parameters, boolean throwException) {
        return this.BuildArguments(parameters, ((WebContentResourceMetaInfo)this.Meta).Headers, throwException);
    }

    private ArrayList<NameValuePair> BuildPostArguments(ContentParameterCollectionInfo parameters, boolean throwException) {
        return this.BuildArguments(parameters, ((WebContentResourceMetaInfo)this.Meta).PostParameters, throwException);
    }

    private ArrayList<NameValuePair> BuildUrlArguments(ContentParameterCollectionInfo parameters, boolean throwException) {
        return this.BuildArguments(parameters, ((WebContentResourceMetaInfo)this.Meta).UrlParameters, throwException);
    }

    private ArrayList<NameValuePair> BuildArguments(ContentParameterCollectionInfo parameters, List<WebContentResourceParameterInfo> needPostParameters, boolean throwException) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (needPostParameters != null) {
            for (WebContentResourceParameterInfo param : needPostParameters) {
                String paramValue = null;
                if (parameters.containsKey(param.Name)) {
                    paramValue = (String)parameters.get(param.Name);
                } else if (!StringExtension.IsNullOrEmpty(param.DefaultValue)) {
                    paramValue = param.DefaultValue;
                }
                if (paramValue == null || paramValue instanceof String && StringExtension.IsNullOrEmpty(paramValue)) {
                    if (!param.Required || !throwException) continue;
                    throw new IllegalArgumentException(String.format("Resource %s require parameter %s", this.CurrentResource.Name, param.Name));
                }
                NameValuePair item = new NameValuePair();
                item.id = StringExtension.IsNullOrEmpty(param.QueryName) ? param.Name : param.QueryName;
                item.value = paramValue;
                list.add(item);
            }
        }
        return list;
    }

    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) {
        ArrayList<NameValuePair> args;
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$WebContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.BuildAbsoluteUri(parameters, false));
        if (((WebContentResourceMetaInfo)this.Meta).Method == HttpMethod.Post && (args = this.BuildPostArguments(parameters, false)).size() > 0) {
            argsSb.append("$From$");
            for (NameValuePair item : args) {
                argsSb.append(String.format("%s:%s", item.id, item.value));
            }
        }
        return argsSb.toString();
    }

    @Override
    public void Verify(ResourceInfo currentResource) {
        if (StringExtension.IsNullOrEmpty(((WebContentResourceMetaInfo)this.Meta).FeedUri)) {
            throw new IllegalArgumentException("Invalid feed uri");
        }
    }
}

