/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.ContentResource.ContentBeanBaseResource;
import LinkFuture.Core.ContentManager.ContentResource.DBContentResourceMetaInfo;
import LinkFuture.Core.ContentManager.ContentResource.DBContentResourceParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;

public class DBContentResource
extends ContentBeanBaseResource<DBContentResourceMetaInfo> {
    public DBContentResource(ResourceInfo currentResource) throws Exception {
        super(currentResource, DBContentResourceMetaInfo.class);
        if (((DBContentResourceMetaInfo)this.Meta).CommandType == null) {
            ((DBContentResourceMetaInfo)this.Meta).CommandType = CommandTypeInfo.StoredProcedure;
        }
    }

    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws SQLException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, ParserConfigurationException, NamingException, ParseException, NoSuchMethodException, InvocationTargetException {
        try (DBHelper helper = new DBHelper(ConfigurationController.AppSettings(((DBContentResourceMetaInfo)this.Meta).ConnectionStringName));){
            ArrayList<NameValuePair> list = this.BuildSqlParameters(parameters);
            for (NameValuePair item : list) {
                helper.addParameter(item.id, item.value);
            }
            ContentResultInfo result = new ContentResultInfo();
            result.Meta = ((DBContentResourceMetaInfo)this.Meta).CommandText;
            result.Success = true;
            result.ErrorCode = 500;
            result.Result = helper.executeToXml(((DBContentResourceMetaInfo)this.Meta).CommandText, ((DBContentResourceMetaInfo)this.Meta).CommandType);
            result.ErrorCode = 200;
            result.ResultType = ContentResultType.Xml;
            ContentResultInfo contentResultInfo = result;
            return contentResultInfo;
        }
    }

    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$DBWebContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.CurrentResource.Meta);
        argsSb.append("$SqlParameters$");
        ArrayList<NameValuePair> list = this.BuildSqlParameters(parameters);
        for (NameValuePair item : list) {
            argsSb.append(String.format("%s:%s", item.id, item.value));
        }
        return argsSb.toString();
    }

    @Override
    public void Verify(ResourceInfo currentResource) {
        if (StringExtension.IsNullOrEmpty(((DBContentResourceMetaInfo)this.Meta).CommandText)) {
            throw new IllegalArgumentException("Invalid CommandText");
        }
        if (StringExtension.IsNullOrEmpty(((DBContentResourceMetaInfo)this.Meta).ConnectionStringName) || StringExtension.IsNullOrEmpty(ConfigurationController.AppSettings(((DBContentResourceMetaInfo)this.Meta).ConnectionStringName))) {
            throw new IllegalArgumentException("Invalid ConnectionStringName");
        }
    }

    private ArrayList<NameValuePair> BuildSqlParameters(ContentParameterCollectionInfo parameters) throws IOException, SQLException, ClassNotFoundException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        SPInfo spMeta = DBHelper.findSPMetaInfo(ConfigurationController.AppSettings(((DBContentResourceMetaInfo)this.Meta).ConnectionStringName), ((DBContentResourceMetaInfo)this.Meta).CommandText, ((DBContentResourceMetaInfo)this.Meta).CommandType);
        if (spMeta != null && spMeta.parameterList != null && spMeta.parameterList.size() > 0) {
            for (SPParameterInfo spParameter : spMeta.parameterList) {
                String spParamName = spParameter.parameterName;
                if (spParamName.startsWith("$")) {
                    spParamName = StringExtension.TrimStart(spParamName, "$");
                }
                if (parameters.containsKey(spParamName)) {
                    Object passedValue = parameters.get(spParamName);
                    if (passedValue == null || StringExtension.IsNullOrEmpty(passedValue.toString())) continue;
                    list.add(new NameValuePair(spParameter.parameterName, passedValue));
                    continue;
                }
                if (((DBContentResourceMetaInfo)this.Meta).Parameters == null) continue;
                for (DBContentResourceParameterInfo param : ((DBContentResourceMetaInfo)this.Meta).Parameters) {
                    if (!param.Name.equalsIgnoreCase(spParamName)) continue;
                    if (!StringExtension.IsNullOrEmpty(param.DefaultValue)) {
                        list.add(new NameValuePair(spParameter.parameterName, param.DefaultValue));
                        continue;
                    }
                    if (!param.Required) continue;
                    throw new IllegalArgumentException(param.Name + " is required");
                }
            }
        }
        return list;
    }
}

