/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.ContentProcessor.ContentBeanBaseProcessor;
import LinkFuture.Core.ContentManager.ContentProcessor.XsltContentProcessorMetaInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultType;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.ObjectExtend.XsltInfo;
import java.util.ArrayList;

public class XsltContentProcessor
extends ContentBeanBaseProcessor<XsltContentProcessorMetaInfo> {
    public XsltContentProcessor(ContentItemInfo content, ProcessorInfo currentProcessor) throws Exception {
        super(content, currentProcessor, XsltContentProcessorMetaInfo.class);
    }

    private XsltInfo ReadXslt(ContentParameterCollectionInfo parameters) throws Exception {
        String xsltPath = parameters.ParamReplace(((XsltContentProcessorMetaInfo)this.Meta).XsltUri);
        return Utility.XsltReader(xsltPath);
    }

    @Override
    public void Transformer(ContentResultCollectionInfo resourceList, ContentParameterCollectionInfo parameters) throws Exception {
        XsltInfo xsltInfo = this.ReadXslt(parameters);
        ArrayList<NameValuePair> argumentsList = new ArrayList<NameValuePair>();
        for (String myParam : xsltInfo.ParameterList) {
            Object myParamValue;
            if (!parameters.containsKey(myParam) || (myParamValue = parameters.get(myParam)) == null) continue;
            argumentsList.add(new NameValuePair(myParam, parameters.get(myParam)));
        }
        ContentResultInfo output = new ContentResultInfo();
        output.ResultType = ContentResultType.Xml;
        output.Success = true;
        output.Result = Utility.xsltTransformer(resourceList.ToContentXml(), xsltInfo.XsltContent, xsltInfo.XsltFilePath, argumentsList.toArray(new NameValuePair[argumentsList.size()]));
        resourceList.clear();
        resourceList.put("$XsltContentProcessor$" + System.currentTimeMillis(), output);
    }

    @Override
    public String BuildProcessorIdentity(ContentParameterCollectionInfo parameters) throws Exception {
        XsltInfo xsltInfo = this.ReadXslt(parameters);
        StringBuilder sb = new StringBuilder();
        sb.append("$XsltContentProcessor$");
        for (String myParam : xsltInfo.ParameterList) {
            sb.append(String.format("%s:%s", myParam, parameters.containsKey(myParam) ? parameters.get(myParam) : ""));
        }
        return sb.toString();
    }

    @Override
    public void Verify(ProcessorInfo currentProcessor) throws Exception {
    }
}

