/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core.ContentManager;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentAction.ContentActionInfo;
import LinkFuture.Core.ContentManager.ContentAction.ContentBaseAction;
import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.Model.AddCycleType;
import LinkFuture.Core.ContentManager.Model.AddInfo;
import LinkFuture.Core.ContentManager.Model.AddParameterInfo;
import LinkFuture.Core.ContentManager.Model.ContentConfigurationInfo;
import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ContentParameterCollectionInfo;
import LinkFuture.Core.ContentManager.Model.ContentResultCollectionInfo;
import LinkFuture.Core.ContentManager.Model.MetaBaseInfo;
import LinkFuture.Core.ContentManager.Model.ParameterInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Core.ContentManager.Model.ValidatorInfo;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;

public class ContentController {
    public static final ContentConfigurationInfo ContentConfigurationMeta = ContentController.Read();

    public static Object LoadResource(String resourceName) throws Exception {
        return ContentController.LoadResource(resourceName, null);
    }

    public static Object LoadResource(String resourceName, Collection<NameValuePair> args) throws Exception {
        ArrayList<NameValuePair> inputList = ContentController.BuildParameters(args);
        ResourceInfo resource = ContentController.FindResource(resourceName);
        IContentResource realAction = (IContentResource)ActivatorsStorage.GetActivator(resource.Type, resource);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item : inputList) {
            list.put(item.id, item.value);
        }
        return realAction.GerResource(null, list);
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName) throws Exception {
        return ContentController.LoadContent(resourceName, null);
    }

    public static ContentResultCollectionInfo LoadContent(String resourceName, Collection<NameValuePair> args) throws Exception {
        return ContentController.LoadContent(resourceName, args, false);
    }

    public static ContentResultCollectionInfo LoadContent(String contentName, Collection<NameValuePair> args, boolean resourceOnly) throws Exception {
        ArrayList<NameValuePair> inputList = ContentController.BuildParameters(args);
        ContentActionInfo meta = new ContentActionInfo(ContentController.FindContentItem(contentName), inputList);
        meta.ResourceOnly = resourceOnly;
        ContentBaseAction action = new ContentBaseAction(meta);
        return action.Action();
    }

    public static String LoadContent(String resourceName, String paramKey1, String paramValue1) throws Exception {
        return ContentController.LoadContentWithParam(resourceName, paramKey1, paramValue1);
    }

    public static String LoadContent(String resourceName, String paramKey1, String paramValue1, String paramKey2, String paramValue2) throws Exception {
        return ContentController.LoadContentWithParam(resourceName, paramKey1, paramValue1, paramKey2, paramValue2);
    }

    public static String LoadContent(String resourceName, String paramKey1, String paramValue1, String paramKey2, String paramValue2, String paramKey3, String paramValue3) throws Exception {
        return ContentController.LoadContentWithParam(resourceName, paramKey1, paramValue1, paramKey2, paramValue2, paramKey3, paramValue3);
    }

    public static String LoadContent(String resourceName, String paramKey1, String paramValue1, String paramKey2, String paramValue2, String paramKey3, String paramValue3, String paramKey4, String paramValue4) throws Exception {
        return ContentController.LoadContentWithParam(resourceName, paramKey1, paramValue1, paramKey2, paramValue2, paramKey3, paramValue3, paramKey4, paramValue4);
    }

    public static String LoadContentWithParam(String resourceName, String ... args) throws Exception {
        if (args == null || args.length == 0) {
            ContentResultCollectionInfo result = ContentController.LoadContent(resourceName);
            result.Params.clear();
            return result.ToContentXml();
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            list.add(new NameValuePair(args[i], args[i + 1]));
        }
        ContentResultCollectionInfo result = ContentController.LoadContent(resourceName, list);
        result.Params.clear();
        return result.ToContentXml();
    }

    public static CaseInsensitiveMap<Object> LoadParameters(String paramName) throws Exception {
        return ContentController.LoadParameters(paramName, null);
    }

    public static CaseInsensitiveMap<Object> LoadParameters(String paramName, Collection<NameValuePair> args) throws Exception {
        if (args == null) {
            args = new ArrayList<NameValuePair>();
        }
        ParameterInfo parameter = ContentController.FindParameter(paramName);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item : args) {
            list.put(item.id, item.value);
        }
        IContentParameter realAction = (IContentParameter)ActivatorsStorage.GetActivator(parameter.Type, parameter);
        return realAction.GerParameter(list);
    }

    private static ArrayList<NameValuePair> BuildParameters(Collection<NameValuePair> args) {
        ArrayList<NameValuePair> output = new ArrayList<NameValuePair>();
        if (args != null) {
            for (NameValuePair item : args) {
                output.add(item);
            }
        }
        output.add(new NameValuePair("LF_APPPath", PathExtension.getApplicationPath()));
        return output;
    }

    public static ResourceInfo FindResource(String name) {
        if (ContentController.ContentConfigurationMeta.ResourceList != null && ContentController.ContentConfigurationMeta.ResourceList.containsKey(name)) {
            return ContentController.ContentConfigurationMeta.ResourceList.get(name);
        }
        throw new IllegalArgumentException("Specific resource not found:" + name);
    }

    public static ParameterInfo FindParameter(String name) {
        if (ContentController.ContentConfigurationMeta.ParameterList != null && ContentController.ContentConfigurationMeta.ParameterList.containsKey(name)) {
            return ContentController.ContentConfigurationMeta.ParameterList.get(name);
        }
        throw new IllegalArgumentException("Specific parameter not found:" + name);
    }

    public static ContentItemInfo FindContentItem(String name) {
        if (ContentController.ContentConfigurationMeta.ContentItemList != null && ContentController.ContentConfigurationMeta.ContentItemList.containsKey(name)) {
            return ContentController.ContentConfigurationMeta.ContentItemList.get(name);
        }
        throw new IllegalArgumentException("Specific content item not found:" + name);
    }

    private static synchronized ContentConfigurationInfo Read() {
        try {
            String contentSettingPath = PathExtension.getConfigFilePath(ConfigurationController.AppSettings("ContentSettingPath"));
            ContentConfigurationInfo config = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(contentSettingPath), ContentConfigurationInfo.class);
            if (config.ResourceList != null) {
                for (MetaBaseInfo item : config.ResourceList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ResourceInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific resource type on:" + ((ResourceInfo)item).Name);
                    }
                    ((ResourceInfo)item).getContentResource();
                }
            }
            if (config.ParameterList != null) {
                for (MetaBaseInfo item : config.ParameterList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ParameterInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific parameter type on:" + ((ParameterInfo)item).Name);
                    }
                    ((ParameterInfo)item).getContentParameter();
                }
            }
            if (config.ProcessorList != null) {
                for (MetaBaseInfo item : config.ProcessorList.values()) {
                    if (StringExtension.IsNullOrEmpty(((ProcessorInfo)item).Type)) {
                        throw new IllegalArgumentException("Please specific processor type on:" + ((ProcessorInfo)item).Name);
                    }
                    ((ProcessorInfo)item).getContentProcessor(null);
                }
            }
            if (config.ContentItemList != null) {
                for (ContentItemInfo content : config.ContentItemList.values()) {
                    if (content.JsonOption == null) {
                        content.JsonOption = new JsonOptionInfo();
                        content.JsonOption.AttributePrefix = "";
                        content.JsonOption.CDataNodeName = "Content";
                        content.JsonOption.IgnoreNamespace = true;
                    }
                    if (content.ValidatorList != null) {
                        for (ValidatorInfo validator : content.ValidatorList) {
                            if (StringExtension.IsNullOrEmpty(validator.Type)) {
                                throw new IllegalArgumentException("Please specific validator type on:" + content.Name);
                            }
                            validator.getContentValidator(content);
                        }
                    }
                    if (config.ResourceList != null && content.ResourceList != null) {
                        int max = 0;
                        for (AddInfo add : content.ResourceList) {
                            if (max < add.Sequence) {
                                max = add.Sequence;
                            }
                            if (add.SelectorList == null) continue;
                            for (AddParameterInfo selector : add.SelectorList.values()) {
                                if (selector.Cycle != null) continue;
                                selector.Cycle = AddCycleType.Before;
                            }
                        }
                        ArrayList[] cachedResourceListTemp = new ArrayList[max + 1];
                        for (AddInfo add : content.ResourceList) {
                            if (!config.ResourceList.containsKey(add.Name)) {
                                throw new IllegalArgumentException("Specific resource type not exist:" + add.Name);
                            }
                            if (cachedResourceListTemp[add.Sequence] == null) {
                                cachedResourceListTemp[add.Sequence] = new ArrayList();
                            }
                            cachedResourceListTemp[add.Sequence].add(config.ResourceList.get(add.Name));
                        }
                        content.CachedResourceList = new ArrayList();
                        for (ArrayList itemList : cachedResourceListTemp) {
                            if (itemList == null) continue;
                            content.CachedResourceList.add(itemList);
                        }
                    }
                    if (config.ParameterList != null) {
                        content.CachedParameterList = new ArrayList();
                        if (content.ParameterList != null) {
                            for (AddInfo add : content.ParameterList) {
                                if (!config.ParameterList.containsKey(add.Name)) {
                                    throw new IllegalArgumentException("Specific parameter type not exist:" + add.Name);
                                }
                                ParameterInfo myParameter = config.ParameterList.get(add.Name);
                                if (myParameter.Global) continue;
                                content.CachedParameterList.add(myParameter);
                            }
                        }
                        for (ParameterInfo globalParameter : config.ParameterList.values()) {
                            if (!globalParameter.Global) continue;
                            content.CachedParameterList.add(globalParameter);
                        }
                    }
                    if (config.ProcessorList == null || content.ProcessorList == null) continue;
                    content.CachedProcessorList = new ArrayList();
                    for (AddInfo processor : content.ProcessorList) {
                        if (!config.ProcessorList.containsKey(processor.Name)) {
                            throw new IllegalArgumentException("Specific processor type not exist:" + processor.Name);
                        }
                        content.CachedProcessorList.add(config.ProcessorList.get(processor.Name));
                    }
                }
            }
            return config;
        }
        catch (Exception ex) {
            Debugger.LogFactory.error("Init content manager failed", (Throwable)ex);
            throw new RuntimeException("Init content manager failed, due to ", ex);
        }
    }
}

