/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Core;

import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import java.lang.reflect.Constructor;

public class ActivatorsStorage {
    public static <T> T GetActivator(String typeString, Object ... args) throws Exception {
        ActivatorsStorage.VerifyClass(typeString);
        return ((Constructor)StaticMemoryCacheHelper.GetNeverExpiredMemoryCache(ActivatorsStorage.getUniqueKey(typeString))).newInstance(args);
    }

    public static void VerifyClass(String typeString) throws Exception {
        if (StringExtension.IsNullOrEmpty(typeString)) {
            throw new IllegalArgumentException("type name can't not be null.");
        }
        String key = ActivatorsStorage.getUniqueKey(typeString);
        StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(key, new Operation<Object>(new Object[]{typeString}){

            @Override
            public Object call() throws Exception {
                String className = (String)this.params[0];
                Debugger.LogFactory.trace("Activating class {}", (Object)className);
                Class<?> myClass = Class.forName(className);
                Constructor<?>[] cst = myClass.getConstructors();
                if (cst.length <= 0) {
                    throw new IllegalArgumentException("Can't init %s type, as it don't have default constructor.");
                }
                return cst[0];
            }
        });
    }

    private static String getUniqueKey(String typeString) {
        return "$ActivatorsStorage$_".concat(typeString);
    }
}

