package LinkFuture.Init;

import java.io.*;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 11/22/13
 * Time: 11:55 AM
 * To change this template use File | Settings | File Templates.
 */
public class Utility {
    //region Find Field by annotation class
    private static Map<String,Field> neverExpiredFieldObject = new ConcurrentHashMap<>();
    public static<T extends Annotation> Field findField(Class<?> type,Class<T> annotationClass) throws Exception {
        String classKey = "$Utility$findField".concat(type.getName()).concat(annotationClass.getName());
        if(!neverExpiredFieldObject.containsKey(classKey))
        {
            neverExpiredFieldObject.put(classKey,findFieldEx(type,annotationClass));
        }
        return neverExpiredFieldObject.get(classKey);
    }
    private static<T extends Annotation> Field findFieldEx(Class<?> type,Class<T> annotationClass){
        for (Field field:type.getDeclaredFields())
        {
            if(field.getAnnotation(annotationClass)!=null)
            {
                return field;
            }
        }
        throw new IllegalArgumentException("Specific ".concat(type.getName()).concat(" must have annotation ").concat(annotationClass.getName()));
    }
    //endregion

    //region File Operation
    public static String getStringFromFile(String filePath) throws IOException {
        return getStringFromFile(filePath, Config.DefaultEncoding);
    }
    public static String getStringFromFile(String filePath,String encoding) throws IOException {
        Debugger.LogFactory.trace("Reading file: {}", filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            return read(new InputStreamReader(new FileInputStream(filePath), encoding));
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }
    public static boolean saveStringToFile(String filePath,String content,boolean isOverwrite) 	{
        Debugger.LogFactory.trace("Save {}",filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            if(isOverwrite)
            {
                //noinspection ResultOfMethodCallIgnored
                file.delete();
            }
            else
            {
                return false;
            }
        }
        boolean saved = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file))){
            bufferedWriter.write(content);
            saved = true;
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return saved;
    }
    @SuppressWarnings("UnusedDeclaration")
    public static byte[] getBytesFromFile(String filePath) throws FileNotFoundException {
        Debugger.LogFactory.trace("Reading file: {}",filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            try(RandomAccessFile bufferedReader = new RandomAccessFile(filePath,"r")){
                long buffLength = bufferedReader.length();
                int length = (int) buffLength;
                if (length != buffLength)
                    throw new IOException("File size >= 2 GB");
                byte[] data = new byte[length];
                bufferedReader.readFully(data);
                bufferedReader.close();
                return data;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }
    public static String read(InputStreamReader inputStreamReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try(BufferedReader reader =  new BufferedReader(inputStreamReader))
        {
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                sb.append(inputLine);
                sb.append(Config.NewLine);
            }
            reader.close();
        }
        return sb.toString();
    }
    public static String read(InputStream inputStream,String encoding) throws IOException {
        return read(new InputStreamReader(inputStream,encoding));
    }
    //endregion
}
