package LinkFuture.Init.ObjectExtend;
import LinkFuture.Init.Utility;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.reflect.Field;

/**
 * User: Cyokin Zhang
 * Date: 10/17/13
 * Time: 11:16 PM
 */
public class JAXBCaseInsensitiveMapAdaptor<T> extends XmlAdapter<JAXBMapElements<T>,CaseInsensitiveMap<T>> {
    @Override
    @SuppressWarnings("unchecked")
    public JAXBMapElements<T> marshal(CaseInsensitiveMap<T> map) throws Exception {
        if(map==null)
        {
            return null;
        }
        JAXBMapElements elements = new JAXBMapElements();
        elements.value= map.values().toArray();
        return elements;
    }

    @Override
    public CaseInsensitiveMap<T> unmarshal(JAXBMapElements<T> input) throws Exception {
        if(input.value.length>0)
        {
            CaseInsensitiveMap<T> map = new CaseInsensitiveMap<>();
            Field keyField = Utility.findField(input.value[0].getClass(), JAXBMapKeyAttribute.class);
            for(T item:input.value)
            {
                map.put(keyField.get(item).toString(),item);
            }
            return map;
        }
        return null;
    }
}