package LinkFuture.Init.Extensions;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.bind.DatatypeConverter;
import java.security.spec.KeySpec;

/**
 * Created by Cyokin on 5/4/2014.
 */
public class SecurityExtension {
    final static String defaultEncryptionSchema = "DESede";
    final static String UNICODE_FORMAT = "UTF8";
    //final static String myEncryptionKey="ThisIsLinkFutureThisIsLinkFuture";

    public static String DESEncrypt(String input,String encryptionKey)
    {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(defaultEncryptionSchema);
            byte[]  arrayBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            KeySpec ks = new DESedeKeySpec(arrayBytes);
            SecretKey key = skf.generateSecret(ks);
            Cipher cipher =Cipher.getInstance(defaultEncryptionSchema);
            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] plainText = input.getBytes(UNICODE_FORMAT);
            byte[] encryptedText = cipher.doFinal(plainText);
            return new String(DatatypeConverter.printBase64Binary(encryptedText));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }
    public static String DESDecrypt(String input,String encryptionKey)
    {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(defaultEncryptionSchema);
            byte[]  arrayBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            KeySpec ks = new DESedeKeySpec(arrayBytes);
            SecretKey key = skf.generateSecret(ks);

            Cipher cipher =Cipher.getInstance(defaultEncryptionSchema);
            cipher.init(Cipher.DECRYPT_MODE, key);
            byte[] encryptedText = DatatypeConverter.parseBase64Binary(input);
            byte[] plainText = cipher.doFinal(encryptedText);
            return new String(plainText);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }
}
