package LinkFuture.Init.Extensions;

import LinkFuture.Init.Config;
import LinkFuture.Init.Debugger;

import java.io.File;
import java.nio.file.Paths;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public class PathExtension {

    /**
     *  Merge getApplicationPath() + path1 + path2 ... always return absolute path
     *  If don;t have application path, we will auto append for you,
     *  PathExtension.FullPhysicalPath("Config/ABC/", "/ContentManager.Config")
     *  PathExtension.FullPhysicalPath("Config/ABC", "ContentManager.Config")
     *  PathExtension.FullPhysicalPath("D:\Codes\Git\JAVA\LinkFuture\", "/Config/ABC/ContentManager.Config")
     *  Both Return  D:\Codes\Git\JAVA\LinkFuture\Config\ABC\ContentManager.Config
     *  Since absolute Path, either start with c:\\ in windows or start with /root/ in unix
     *  So please pass path without / in windows
     */
    public static String FullPhysicalPath (String ... paths) {
        if(IsAbsolute(paths[0]))
        {
            String[] subPath = new String[paths.length-1];
            for (int i=0;i<paths.length-1;i++)
            {
                subPath[i] = paths[i+1];
            }
            return Paths.get(paths[0],subPath).toString();
        }
        return Paths.get(getApplicationPath(),paths).toString();
    }

    /**
     * IsAbsolute Path, start with c:\\ in windows or start with /root/ in unix
     * @param path
     * @return
     */
    public static boolean IsAbsolute(String path)
    {
        return new File(path).isAbsolute();
    }

    //region applicationPath
    private static String applicationPath;
    public static void setApplicationPath(String path){
        if(!StringExtension.IsNullOrEmpty(path))
        {
            applicationPath = path;
        }
    }
    /**
     *  Get getApplicationPath,
     *  either return D:\Codes\Git\JAVA\LinkFuture or \Codes\Git\JAVA\LinkFuture
     */
    public synchronized static String getApplicationPath(){
        //return new File("").getAbsolutePath();
        //return PathExtensions.class.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        //http://stackoverflow.com/questions/218061/get-the-applications-path
        //return System.getProperty("user.dir");
        //can't use Debugger class, this class must design with no dependency
        if(StringExtension.IsNullOrEmpty(applicationPath))
        {
            Debugger.LogFactory.trace("Getting application path");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if(classLoader==null || classLoader.getResource("")==null)
            {
                applicationPath = System.getProperty("user.dir");
                Debugger.LogFactory.trace("Can't find getEnclosingClass, use user.dir");
            }
            else
            {
                //noinspection ConstantConditions
                String appPath= new File(classLoader.getResource("").getPath()).getPath();
                String webInfPath = System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator")  + "classes";
                //web path , but not work if the class in *.war file
                if(appPath.endsWith(webInfPath))
                {
                    Debugger.LogFactory.trace("Use WEB-INF Path");
                    applicationPath = StringExtension.TrimEnd(appPath,webInfPath);
                }
                else
                {
                    applicationPath = System.getProperty("user.dir");
                }
            }
            Debugger.LogFactory.trace(applicationPath);
        }
         return applicationPath;
    }

    /**
     * Find a file path related config folder
     * @return
     */
    public static String getConfigFilePath(String filePath){
           return PathExtension.FullPhysicalPath(Paths.get(Config.ConfigFolder, filePath).toString());
    }
    //endregion

    //region OS
    private static OS cachedOS = null;
    public static OS getOS(){
        if(cachedOS==null)
        {
            cachedOS= readOS();
            Debugger.LogFactory.trace("OS is " + cachedOS.toString());
        }
        return cachedOS;
    }
    private static OS readOS(){
        String OSName = System.getProperty("os.name").toLowerCase();
        if(OSName.contains(OS.Win.toString().toLowerCase()))
        {
            return OS.Win;
        }
        if(OSName.contains(OS.Mac.toString().toLowerCase()))
        {
            return OS.Mac;
        }
        if(OSName.contains(OS.Unix.toString().toLowerCase()))
        {
            return OS.Unix;
        }
        if(OSName.contains(OS.Solaris.toString().toLowerCase()))
        {
            return OS.Solaris;
        }
        return OS.Others;
    }
    public enum OS
    {
        Win,
        Mac,
        Unix,
        Solaris,
        Others
    }
    //endregion
}
