package LinkFuture.Init;

import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 4:22 PM
 * Debugger.
 */
public class Debugger {
    public final static org.slf4j.Logger LogFactory = LoggerFactory.getLogger("LinkFuture");
    public final static Marker fatalMarker = MarkerFactory.getMarker("FATAL");
    public synchronized static void fatal(String msg,Throwable ex)
    {
        LogFactory.error(fatalMarker, msg, ex);
    }
    public synchronized static void fatal(String msg)
    {
        LogFactory.error(fatalMarker,msg);
    }
    public synchronized static String getDetail(Exception ex)
    {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
}
