package LinkFuture.Init.ConfigurationManager;

import LinkFuture.Init.Config;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Utility;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 1:50 PM
 * this class must design with no dependency
 */
public class ConfigurationController {
    public static ConfigurationInfo ConfigurationMeta = Read();

    public static boolean IsDebug = ConfigurationController.AppSettings("IsDebug").equalsIgnoreCase("true");
    public static String DefaultJsCrunchFilePath = PathExtension.FullPhysicalPath(ConfigurationController.AppSettings("JsCrunchFilePath"));
    public static String DefaultCssCrunchFilePath = PathExtension.FullPhysicalPath(ConfigurationController.AppSettings("CssCrunchFilePath"));

    public static String AppSettings(String key){
        if(ConfigurationMeta != null && ConfigurationMeta.AppSettings !=null && ConfigurationMeta.AppSettings.containsKey(key))
        {
            return ConfigurationMeta.AppSettings.get(key).Value;
        }
        return Config.Empty;
    }
    private synchronized static ConfigurationInfo Read(){
        try {
            String configurationPath =  PathExtension.getConfigFilePath(Config.ApplicationConfigurationFileName);
            Debugger.LogFactory.trace("Init config file:{}", configurationPath);
            String configFileContent = Utility.getStringFromFile(configurationPath);
            if(configFileContent.trim().startsWith("<"))
            {
                ConfigurationInfo config =  fromXml(configFileContent, ConfigurationInfo.class);
                if(config.ProxySettings!=null)
                {
                    config.ProxySettings.SetupProxy();
                }
                return config;
            }
            else
            {
                //from properties
                return fromProperties(configFileContent);
            }
        }
        catch (Exception ex)
        {
            Debugger.LogFactory.error("Init application configuration failed",ex);
            throw new RuntimeException("Init application configuration failed", ex);
        }
    }
    private static ConfigurationInfo fromProperties(String configFileContent) throws IOException {
        Properties file = new Properties();
        file.load(new StringReader(configFileContent));
        ConfigurationInfo config = new ConfigurationInfo();
        config.AppSettings = new HashMap<>();
        for (Map.Entry<Object,Object> item: file.entrySet())
        {
            AppSettingInfo setting = new AppSettingInfo();
            setting.Key = item.getKey().toString();
            setting.Value = item.getValue().toString();
            if(setting.Key.startsWith("ProxySettings."))
            {
                if(config.ProxySettings!=null)
                {
                    config.ProxySettings = new ProxySettingsInfo();
                }
                if(setting.Key.startsWith("ProxySettings.HttpProxy") && config.ProxySettings.HttpProxy!=null)
                {
                    config.ProxySettings.HttpProxy = new ProxyInfo();
                }
                if(setting.Key.startsWith("ProxySettings.HttpsProxy") && config.ProxySettings.HttpsProxy!=null)
                {
                    config.ProxySettings.HttpsProxy = new ProxyInfo();
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Host"))
                {
                    config.ProxySettings.HttpProxy.Host = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Port"))
                {
                    config.ProxySettings.HttpProxy.Port = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.UserName"))
                {
                    config.ProxySettings.HttpProxy.UserName = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpProxy.Password"))
                {
                    config.ProxySettings.HttpProxy.Password = setting.Value;
                    continue;
                }
                //https
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Host"))
                {
                    config.ProxySettings.HttpsProxy.Host = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Port"))
                {
                    config.ProxySettings.HttpsProxy.Port = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.UserName"))
                {
                    config.ProxySettings.HttpsProxy.UserName = setting.Value;
                    continue;
                }
                if(setting.Key.equalsIgnoreCase("ProxySettings.HttpsProxy.Password"))
                {
                    config.ProxySettings.HttpsProxy.Password = setting.Value;
                    continue;
                }
            }
            else
            {
                config.AppSettings.put(setting.Key, setting);
            }
        }
        return config;
    }

    private static<T> T fromXml(String xmlString,Class<T> targetClass)
    {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(targetClass);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            //noinspection unchecked
            return (T) unmarshaller.unmarshal(new StringReader(xmlString));
        } catch (JAXBException e) {
            Debugger.LogFactory.error("Init application configuration failed", e);
        }
        //noinspection UnusedAssignment
        context = null;
        return null;
    }
}
