package LinkFuture.Init;

import javax.naming.InitialContext;
import java.io.File;
import java.net.URL;
import java.util.TimeZone;

/**
 * User: Cyokin Zhang
 * Date: 9/25/13
 * Time: 5:21 PM
 * don't use dynamic code here, for avoid dependency conflict.
 */
public class Config {
    public final static String DefaultTimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSSXXX";
    public final static String ISO8601TimeFormat = "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'";
    public final static TimeZone UTCTimeZone = TimeZone.getTimeZone("UTC");
    public final static String NewLine = System.getProperty("line.separator");
    public final static String DefaultEncoding ="UTF-8";
    public final static String Empty ="";
    public final static String Version = "1.0.3";

    public final static String ApplicationConfigurationFileName = ReadConfigFileName();
    /***
     * read config file folder with following steps
          1) /comp/env/LinkFuture/config_dir
          2) Resource folder
          3) Application path + /Static/Config
     */
    public final static String ConfigFolder = ReadConfigFolder();
    public static int MaxParallelThread = 10;

    private static String ReadConfigFolder(){
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_dir").toString();
        }
        catch (Exception e)
        {
            Debugger.LogFactory.warn("Can't find Application.Config path at java:/comp/env/LinkFuture/config_dir");
            ClassLoader classLoader = Config.class.getClassLoader();
            URL applicationFile = classLoader.getResource(ApplicationConfigurationFileName);
            if(applicationFile!=null)
            {
                File resourceFile = new File(applicationFile.getFile());
                if(resourceFile.exists())
                {
                    return resourceFile.getParent().toString();
                }
            }
            Debugger.LogFactory.warn("Can't find Application.Config at resource");
            return "Static/Config";
        }
    }
    private static String ReadConfigFileName(){
        try {
            InitialContext cxt = new InitialContext();
            return cxt.lookup("java:/comp/env/LinkFuture/config_fileName").toString();
        }
        catch (Exception e)
        {
            return "Application.Config";
        }
    }
}
