package LinkFuture.Core.OperationManager;

import LinkFuture.Init.Config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 8:24 PM
 */
public class OperationController {
    /*
    *    run with retry, handled exception when failed, raise error operation.handleException
    * */
    public static Object runWithRetry(int maxAttempts,Operation operation){
        for (int count = 0; count < maxAttempts; count++) {
            try {
                return operation.call();
            } catch (Exception e) {
                operation.handleException(e);
            }
        }
        return null;
    }
    /*
    *   run with retry, throw exception after retry.
    * */
    public static Object runWithRetryThrowException(int maxAttempts,Operation operation,boolean throwException) throws Exception {
        Exception ex=null;
        for (int count = 0; count < maxAttempts; count++) {
            try {
                return operation.call();
            } catch (Exception e) {
                operation.handleException(e);
                ex = e;
            }
        }
        if(throwException && ex!=null)
        {
            throw ex;
        }
        return null;
    }
    /*
    *   run without handle exception
    * */
    public static Object run(Operation operation) throws Exception {
        return operation.call();
    }
    public static<T> List<T> runInParallel(List<Operation<T>> tasks,int maxThread) throws InterruptedException, ExecutionException {
        ExecutorService taskExecutor = Executors.newFixedThreadPool(maxThread);
        List<Future<T>> results= taskExecutor.invokeAll(tasks);
        taskExecutor.shutdown();
        List<T> output = new ArrayList<>();
        for (Future<T> item:results)
        {
            if(item.isDone())
            {
                output.add(item.get());
            }
        }
        return output;
    }
    public static<T> List<T> runInParallel(List<Operation<T>> tasks) throws InterruptedException, ExecutionException {
        return runInParallel(tasks, Config.MaxParallelThread);
    }
}
