package LinkFuture.Core.MemoryManager.Redis;

import LinkFuture.Core.Utility;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

import java.io.Serializable;
import java.net.URI;

/**
 * Created by Cyokin on
 * 11/9/2014.
 */
public class RedisHelper {
    private final JedisPool jedisPool;
    private Jedis jedis;
    /**
     * RedisHelper
     * @param redisServersUrl :redis://[userName]:[password]@localhost:6380/[dbID]
     * @param timeout : ms
     */
    public RedisHelper(final URI redisServersUrl,int timeout) {
        jedisPool = new JedisPool(new JedisPoolConfig(), redisServersUrl, timeout);
        jedis = jedisPool.getResource();
       /* new Thread(new OperationRunnable() {
            @Override
            public void run() {
                Jedis subscriber = new Jedis(redisServersUrl);
                subscriber.psubscribe(new RedisEvent(),"__keyspace@0__:myKey del");
            }
        }).start();*/
    }

    /**
     * @param redisServersUrl: redis://[userName]:[password]@localhost:6380/[dbID]
     */
    public RedisHelper(URI redisServersUrl) {
        this(redisServersUrl,Protocol.DEFAULT_TIMEOUT);
    }
    public void selectDB(int dbNumber)
    {
        jedis.select(dbNumber);
    }
    public void disconnect(){
        jedis.disconnect();
        jedis.close();
        jedisPool.close();
        jedisPool.destroy();
    }

    //region String
    public void set(String key,String value)
    {
        jedis.set(key,value);
    }
    public void set(String key,String value,int second)
    {
        jedis.setex(key,second,value);
    }
    public String get(String key)
    {
        return jedis.get(key);
    }
    public void del(String key)
    {
         jedis.del(key);
    }
    //endregion

    //region Object
    public void setObject(String key,Serializable value,int second)
    {
        jedis.setex(key.getBytes(), second, Utility.toByte(value));
    }
    public void setObject(String key,Serializable value)
    {
        jedis.set(key.getBytes(), Utility.toByte(value));
    }
    public<T> T getObject(String key)
    {
        return Utility.fromByte(jedis.get(key.getBytes()));
    }
    public void delObject(String key)
    {
        jedis.del(key.getBytes());
    }
    //endregion

    //region Bytes
    public void setByte(String key,byte[] value)
    {
        jedis.set(key.getBytes(), value);
    }
    public void setByte(String key,byte[] value,int second)
    {
        jedis.setex(key.getBytes(), second, value);
    }
    public byte[] getByte(String key)
    {
        return jedis.get(key.getBytes());
    }
    public void delByte(String key){
        jedis.del(key.getBytes());
    }
    //endregion
}
