package LinkFuture.Core.JsonManager;

import LinkFuture.Init.Config;

/**
 * User: Cyokin Zhang
 * Date: 10/23/13
 * Time: 12:19 PM
 */
public class JsonController {
    public static String convertJsonToXml(String jsonString)
    {
        org.json.JSONObject jsonObject=  new org.json.JSONObject(jsonString);
        return org.json.XML.toString(jsonObject);
    }
    public static String convertXmlToJson(String xmlString,JsonOptionInfo option) {
        try(JsonObjectReader reader = new JsonObjectReader(xmlString))
        {
            JsonObjectInfo root = reader.toJsonObj();
            if(option.IgnoreRoot)
            {
                return root.toChildJson(option);
            }
            return root.toJson(option);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    public static String convertXmlToJson(String xmlString) {
        JsonOptionInfo option = new JsonOptionInfo();
        option.AttributePrefix= Config.Empty;
        option.NamespacePrefix = Config.Empty;
        option.IgnoreNamespace = true;
        option.IgnoreRoot = false;
        option.CDataNodeName = "Content";
        option.ValueOption = JsonValueOption.AllString;
        return convertXmlToJson(xmlString,option);
    }
}
