package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Extensions.StringExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.sql.*;
import java.util.ArrayList;
import java.util.Map;

/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 10/19/13
 * Time: 3:08 PM
 */
public class DBXmlReader extends DBReader {

    public DBXmlReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }
    public String Read() throws ParserConfigurationException, IOException, SQLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element result = doc.createElement("DBResult");
        doc.appendChild(result);
        boolean hadResults = true;
        while(hadResults)
        {
            ResultSet rs = statement.getResultSet();
            result.appendChild(this.read(rs,doc));
            hadResults = statement.getMoreResults();
        }
        if(this.statement instanceof CallableStatement)
        {
            Map<String,Object> outputParameterList = DBHelper.ReadOutputParameterList(this.spMetaInfo,(CallableStatement)this.statement);
            for (String key:outputParameterList.keySet())
            {
                result.setAttribute(StringExtension.XmlNodeNameEscape(key),outputParameterList.get(key).toString());
            }
        }
        return Utility.xmlNodeToString(doc);
    }
    private Element read(ResultSet rs,Document doc) throws SQLException, ParserConfigurationException, IOException {
        ResultSetMetaData metaData = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(metaData);
        Element table = doc.createElement("Table");
        while (rs.next()) {
            Element row =doc.createElement("Row");
            ArrayList<Element> columnList = fillObject(rs,resultMetaInfo,doc);
            for (Element node:columnList)
            {
                row.appendChild(node);
            }
            table.appendChild(row);
        }
        return table;
    }
    private ArrayList<Element> fillObject(ResultSet rs,TableInfo resultMetaInfo,Document doc) throws SQLException {
        ArrayList<Element> list = new ArrayList<>();
        for (int i = 1; i <= resultMetaInfo.columnList.size(); i++) {
            ColumnInfo column =   resultMetaInfo.columnList.get(i -1);
            Element newNode = doc.createElement(StringExtension.XmlNodeNameEscape(column.columnName));
            newNode.appendChild(doc.createTextNode(rs.getString(i)));
            list.add(newNode);
        }
        return  list;
    }
}
