package LinkFuture.Core.DBHelper;

import LinkFuture.Core.DBHelper.Model.ColumnInfo;
import LinkFuture.Core.DBHelper.Model.FieldInfo;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.TableInfo;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * User: Cyokin Zhang
 * Date: 10/19/13
 * Time: 3:18 PM
 */
public class DBBeanReader extends DBReader {
    public DBBeanReader(Statement statement, SPInfo spMetaInfo) {
        super(statement, spMetaInfo);
    }
    public ArrayList<ArrayList<?>> Read(Class<?>... outputType) throws Exception {
        ArrayList<ArrayList<?>> result = new ArrayList<>();
        int resultIndex =0;
        boolean hadResults = true;
        while(hadResults)
        {
            ResultSet rs = this.statement.getResultSet();
            if(resultIndex < outputType.length)
            {
                ArrayList<?> item = read(rs, outputType[resultIndex]);
                result.add(item);
            }
            resultIndex++;
            hadResults = this.statement.getMoreResults();
        }
        return result;
    }

    public static <T> ArrayList<T> read(ResultSet rs,Class<T> type) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        TableInfo resultMetaInfo = DBHelper.findResultsColumnInfo(rsmd);
        ArrayList<T> result = new ArrayList<>();
        while (rs.next()) {
            T newRow = fillObject(rs,resultMetaInfo,type);
            result.add(newRow);
        }
        return result;
    }
    public static <T> T fillObject(ResultSet rs,TableInfo resultMetaInfo,Class<T> type) throws Exception {
        T newInstance = type.newInstance();
        HashMap<String,FieldInfo> fieldList =DBHelper.findClassFieldInfo(type) ;
        for (int i = 1; i <= resultMetaInfo.columnList.size(); i++) {
            ColumnInfo column =   resultMetaInfo.columnList.get(i -1);
            String fieldKey = column.columnName.toLowerCase();
            if(fieldList.containsKey(fieldKey))
            {
                FieldInfo fieldMeta = fieldList.get(fieldKey);
                fieldMeta.field.setAccessible(true);
                Object objValue = rs.getObject(i);
                if(objValue!=null)
                {
                    fieldMeta.field.set(newInstance,rs.getObject(i));
                }
            }
        }
        //fill data to sub entity
        for (String fieldKey:fieldList.keySet())
        {
            FieldInfo fieldMeta = fieldList.get(fieldKey);
            if(fieldMeta.columnAttribute!=null && fieldMeta.columnAttribute.isEntity())
            {
                fieldMeta.field.setAccessible(true);
                Object subInstance = fillObject(rs,resultMetaInfo,fieldMeta.field.getType());
                fieldMeta.field.set(newInstance,subInstance);
            }
        }
        return newInstance;
    }
}
