package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.JsonManager.JsonController;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 12/4/13
 * Time: 11:42 AM
 * To change this template use File | Settings | File Templates.
 */
public class ContentResultCollectionInfo extends CaseInsensitiveMap<ContentResultInfo> {
    //public boolean ResourceOnly;
    public String ToContentXml() {
        StringBuilder sb = new StringBuilder();
        if (this.size() > 1)
        {
            sb.append("<Root>");
        }
        for (Map.Entry<String,ContentResultInfo> item : this.entrySet())
        {
            ContentResultInfo result = item.getValue();
            if (this.size() > 1)
            {
                sb.append("<Content");
                sb.append(" name=\"");
                sb.append(item.getKey());
                sb.append("\"");
                sb.append(" success=\"");
                sb.append(result.Success);
                sb.append("\"");
                sb.append(">");
            }
            Object value = result.Result;
            if(result.Success && value!=null)
            {
                if (value instanceof  String)
                {
                    switch (result.ResultType)
                    {
                        case Json:
                            //must append root element, otherwise we may missing node;
                            value = "<Root>".concat(JsonController.convertJsonToXml((String)value)).concat("</Root>");
                            break;
                        case Binary:
                            value = "";
                            break;
                    }
                    sb.append(Utility.removeXmlDeclaration((String) value));
                }
                else
                {
                    sb.append(Utility.removeXmlDeclaration(Utility.toXml(value)));
                }
            }
            if (this.size() > 1)
            {
                sb.append("</Content>");
            }
        }
        if (this.size() > 1)
        {
            sb.append("</Root>");
        }
        return sb.toString();
    }
    public String ToResourceOnlyXml(){
        StringBuilder sb = new StringBuilder();
        sb.append("<Root>");
        for (Map.Entry<String,ContentResultInfo> item : this.entrySet())
        {
            ContentResultInfo result = item.getValue();
            sb.append("<Content");

            sb.append(" name=\"");
            sb.append(item.getKey());
            sb.append("\"");

            sb.append(" success=\"");
            sb.append(result.Success);
            sb.append("\"");

            sb.append(" code=\"");
            sb.append(result.ErrorCode);
            sb.append("\"");

            sb.append(" loadTimeMs=\"");
            sb.append(result.LoadTimeInMs);
            sb.append("\"");

            if(result.Meta!=null)
            {
                sb.append(" meta=\"");
                sb.append(StringExtension.XmlEscape(result.Meta));
                sb.append("\"");
            }
            sb.append(">");
            Object value = result.Result;
            if(result.Success && value!=null)
            {
                if (value instanceof  String)
                {
                    switch (result.ResultType)
                    {
                        case Json:
                            value = "<Root>".concat(JsonController.convertJsonToXml((String)value)).concat("</Root>");
                            break;
                        case Binary:
                            value = "";
                            break;
                    }
                    sb.append(Utility.removeXmlDeclaration((String) value));
                }
                else
                {
                    sb.append(Utility.removeXmlDeclaration(Utility.toXml(value)));
                }
            }
            else
            {
                sb.append("<ErrorMessage>");
                sb.append(StringExtension.XmlEscape(Debugger.getDetail(result.Error)));
                sb.append("</ErrorMessage>");
            }
            sb.append("</Content>");
        }
        sb.append("</Root>");
        return sb.toString();
    }

    public String ToContentJson() throws IOException {
        if(this.size() == 1)
        {
            ContentResultInfo result = (ContentResultInfo)this.values().toArray()[0];
            return GenerateJson(result);
        }
        StringWriter sb = new StringWriter();
        int index = 0;
        sb.append("{");
        sb.append("\"Root\":");
        sb.append("{\"Content\":[");
        for (Map.Entry<String,ContentResultInfo> item : this.entrySet())
        {
            ContentResultInfo result = item.getValue();
            sb.append("{");
            sb.append("\"name\":");
            StringExtension.JsonQuote(item.getKey(), sb);
            sb.append(",\"success\":");
            StringExtension.JsonQuote(String.valueOf(result.Success), sb);
            //sb.append(",");
            if(result.Success && result.Result!=null)
            {
                sb.append(",\"response\":");
                sb.append(GenerateJson(result));
                //sb.append(RemoveJsonHeader(GenerateJson(result)));
            }
            sb.append("}");
            index ++;
            if(index!=this.size())
            {
                sb.append(",");
            }
        }
        sb.append("]}");
        sb.append("}");
        return sb.toString();
    }
    public String ToResourceOnlyJson() throws IOException {
        StringWriter sb = new StringWriter();
        int index = 0;
        if (this.size() > 1)
        {
            sb.append("{");
            sb.append("\"Root\":");
            sb.append("{\"Content\":[");
        }
        for (Map.Entry<String,ContentResultInfo> item : this.entrySet())
        {
            ContentResultInfo result = item.getValue();
            sb.append("{");
            sb.append("\"name\":");
            StringExtension.JsonQuote(item.getKey(), sb);
            sb.append(",\"success\":");
            StringExtension.JsonQuote(String.valueOf(result.Success), sb);
            sb.append(",\"code\":");
            StringExtension.JsonQuote(String.valueOf(result.ErrorCode), sb);
            sb.append(",\"loadTimeMs\":");
            StringExtension.JsonQuote(String.valueOf(result.LoadTimeInMs), sb);
            if(result.Meta!=null)
            {
                sb.append(",\"meta\":");
                StringExtension.JsonQuote(result.Meta, sb);
            }
            //sb.append(",");
            if(result.Success && result.Result!=null)
            {
                sb.append(",\"response\":");
                sb.append(GenerateJson(result));
                //sb.append(RemoveJsonHeader(GenerateJson(result)));
            }
            else
            {
                sb.append("\"errorMessage\":");
                StringExtension.JsonQuote(Debugger.getDetail(result.Error), sb);
            }
            sb.append("}");
            index ++;
            if(index!=this.size())
            {
                sb.append(",");
            }
        }
        if (this.size() > 1)
        {
            sb.append("]}");
            sb.append("}");
        }
        return sb.toString();
    }
    private String GenerateJson(ContentResultInfo result)
    {
        Object value = result.Result;
        if (value instanceof  String)
        {
            switch (result.ResultType)
            {
                case Xml:

                    value = JsonController.convertXmlToJson((String) value);
                    break;
                case Binary:
                    value = "";
                    break;
            }
        }
        else
        {
            value = Utility.toJson(value);
        }
        return (String) value;
    }
    private String RemoveJsonHeader(String jsonString)
    {
        return StringExtension.TrimEnd(StringExtension.TrimStart(jsonString.trim(),"{"),"}");
    }
    public ContentParameterCollectionInfo Params;
}
