package LinkFuture.Core.ContentManager.Model;

import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Init.ObjectExtend.JAXBMapKeyAttribute;

import javax.xml.bind.annotation.*;
import java.util.ArrayList;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */

@XmlRootElement(name = "ContentItem")
public class ContentItemInfo
{
    @XmlAttribute(name = "Name")
    @JAXBMapKeyAttribute
    public String Name;

    @XmlAttribute(name = "CacheSettingKey")
    public String CacheSettingKey;

    @XmlAttribute(name = "OutputCacheProfileKey")
    public String OutputCacheProfileKey;

    /**
     * design when IgnoreException = "true", but want to shorter cache time.
     */
    @XmlAttribute(name = "IgnoredExceptionOutputCacheProfileKey")
    public String IgnoredExceptionOutputCacheProfileKey;

    @XmlElement(name = "Validator")
    @XmlElementWrapper(name = "ValidatorList")
    public  ArrayList<ValidatorInfo> ValidatorList;

    @XmlElement(name = "Parameter")
    @XmlElementWrapper(name = "ParameterList")
    public ArrayList<AddInfo> ParameterList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ParameterInfo> CachedParameterList;

    @XmlElement(name = "Resource")
    @XmlElementWrapper(name = "ResourceList")
    public ArrayList<AddInfo> ResourceList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ArrayList<ResourceInfo>> CachedResourceList;

    @XmlElement(name = "Processor")
    @XmlElementWrapper(name = "ProcessorList")
    public ArrayList<AddInfo> ProcessorList;

    //cached object after reader
    @XmlTransient
    public ArrayList<ProcessorInfo> CachedProcessorList;

    @XmlElement(name ="JsonOption")
    public JsonOptionInfo JsonOption;

    public AddInfo FindResourceAddInfo(String resourceName)
    {
        for (AddInfo item:this.ResourceList)
        {
            if(item.Name.equalsIgnoreCase(resourceName))
            {
                return item;
            }
        }
        return null;
    }
    public AddInfo FindProcessorAddInfo(String processorName)
    {
        for (AddInfo item:this.ProcessorList)
        {
            if(item.Name.equalsIgnoreCase(processorName))
            {
                return item;
            }
        }
        return null;
    }

}