package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.MongoDBHelper.MongoDBHelper;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Extensions.StringExtension;

import java.util.List;

/**
 * Created by Cyokin on 1/2/2015.
 */
public class MongoDBContentResource extends ContentBeanBaseResource<DBContentResourceMetaInfo> {
    public MongoDBContentResource(ResourceInfo currentResource) throws Exception {
        super(currentResource, DBContentResourceMetaInfo.class);
    }

    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        MongoDBHelper helper = new MongoDBHelper(ConfigurationController.AppSettings(this.Meta.ConnectionStringName));
        ContentResultInfo result = new ContentResultInfo();
        result.Meta = this.Meta.CommandText;
        result.Success = true;
        result.ErrorCode = 500;
        String commandScript = parameters.ParamReplace(this.Meta.CommandText);
        result.Result =  helper.execute(commandScript,parameters).toString();
        result.ErrorCode = 200;
        result.ResultType = ContentResultType.Json;
        return result;
    }

    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$MongoDBContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.CurrentResource.Meta);
        argsSb.append("$ScriptCode$");
        String commandScript = parameters.ParamReplace(this.Meta.CommandText);
        argsSb.append(commandScript);
        argsSb.append("$Parameters$");
        List<String> requiredParam = MongoDBHelper.readFunctionParameters(commandScript);
        if(requiredParam.size()>0)
        {
            for (String key :requiredParam)
            {
                if(parameters.containsKey(key))
                {
                    argsSb.append(key);
                    argsSb.append("=>");
                    argsSb.append(parameters.get(key));
                }
            }
        }
        return argsSb.toString();
    }

    @Override
    public void Verify(ResourceInfo currentResource) throws Exception {
        if(StringExtension.IsNullOrEmpty(this.Meta.CommandText))
        {
            throw new IllegalArgumentException("Invalid CommandText");
        }
        if(StringExtension.IsNullOrEmpty(this.Meta.ConnectionStringName) || StringExtension.IsNullOrEmpty(ConfigurationController.AppSettings(this.Meta.ConnectionStringName)))
        {
            throw new IllegalArgumentException("Invalid ConnectionStringName");
        }
    }
}
