package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.DBHelper.Model.CommandTypeInfo;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Core.DBHelper.DBHelper;
import LinkFuture.Core.DBHelper.Model.SPInfo;
import LinkFuture.Core.DBHelper.Model.SPParameterInfo;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;


/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public class DBContentResource extends ContentBeanBaseResource<DBContentResourceMetaInfo> {
    public DBContentResource(ResourceInfo currentResource) throws Exception {
        super(currentResource,DBContentResourceMetaInfo.class);
        //StoredProcedure as default command type
        if(this.Meta.CommandType==null)
        {
            this.Meta.CommandType = CommandTypeInfo.StoredProcedure;
        }
    }
    @Override
    public ContentResultInfo RetrieveResource(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws SQLException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, ParserConfigurationException, NamingException, ParseException, NoSuchMethodException, InvocationTargetException {
        try(DBHelper helper = new DBHelper(ConfigurationController.AppSettings(this.Meta.ConnectionStringName))){
            ArrayList<NameValuePair> list = this.BuildSqlParameters(parameters);
            for (NameValuePair item:list)
            {
                helper.addParameter(item.id, item.value);
            }
            ContentResultInfo result = new ContentResultInfo();
            result.Meta = this.Meta.CommandText;
            result.Success = true;
            result.ErrorCode = 500;
            result.Result =  helper.executeToXml(this.Meta.CommandText, this.Meta.CommandType);
            result.ErrorCode = 200;
            result.ResultType = ContentResultType.Xml;
            return result;
        }
    }
    @Override
    public String BuildResourceIdentity(ContentItemInfo content, ContentParameterCollectionInfo parameters) throws Exception {
        StringBuilder argsSb = new StringBuilder();
        argsSb.append("$DBWebContentResource$");
        argsSb.append(this.CurrentResource.Name);
        argsSb.append("=>");
        argsSb.append(this.CurrentResource.Meta);
        argsSb.append("$SqlParameters$");
        ArrayList<NameValuePair> list = this.BuildSqlParameters(parameters);
        for (NameValuePair item:list)
        {
            argsSb.append(String.format("%s:%s", item.id, item.value));
        }
        return argsSb.toString();
    }
    @Override
    public void Verify(ResourceInfo currentResource){
        if(StringExtension.IsNullOrEmpty(this.Meta.CommandText))
        {
            throw new IllegalArgumentException("Invalid CommandText");
        }
        if(StringExtension.IsNullOrEmpty(this.Meta.ConnectionStringName) || StringExtension.IsNullOrEmpty(ConfigurationController.AppSettings(this.Meta.ConnectionStringName)))
        {
            throw new IllegalArgumentException("Invalid ConnectionStringName");
        }
    }
    private ArrayList<NameValuePair> BuildSqlParameters(ContentParameterCollectionInfo parameters) throws IOException, SQLException, ClassNotFoundException, NamingException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<NameValuePair> list = new ArrayList<>();
        SPInfo spMeta= DBHelper.findSPMetaInfo(ConfigurationController.AppSettings(this.Meta.ConnectionStringName),this.Meta.CommandText,this.Meta.CommandType);
        if(spMeta!=null && spMeta.parameterList!=null && spMeta.parameterList.size()>0)
        {
            for (SPParameterInfo spParameter:spMeta.parameterList)
            {
                String  spParamName =   spParameter.parameterName;
                //TODO:should I handle $ case here, as some parameter name in SP will have $ prex, but the passed parameters is not necessary have $, am I correct?
                if (spParamName.startsWith("$")) spParamName = StringExtension.TrimStart(spParamName, "$");
                if(parameters.containsKey(spParamName))
                {
                    Object passedValue = parameters.get(spParamName);
                    if (passedValue!=null && !StringExtension.IsNullOrEmpty(passedValue.toString()))
                    {
                        list.add(new NameValuePair(spParameter.parameterName,passedValue));
                    }
                    continue;
                }
                //if not found from query take it from meta
                if(this.Meta.Parameters!=null)
                {
                    for(DBContentResourceParameterInfo param:this.Meta.Parameters)
                    {
                        if (param.Name.equalsIgnoreCase(spParamName))
                        {
                            if(!StringExtension.IsNullOrEmpty(param.DefaultValue))
                            {
                                list.add(new NameValuePair(spParameter.parameterName,param.DefaultValue));
                            }
                            else
                            {
                                if(param.Required)
                                {
                                    throw new IllegalArgumentException(param.Name + " is required");
                                }
                            }
                        }
                    }
                }
            }
        }
        return list;
    }
}
