package LinkFuture.Core.ContentManager.ContentResource;

import LinkFuture.Core.ContentManager.Model.ResourceInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBeanBaseResource<T> extends ContentBaseResource {
    public ContentBeanBaseResource(ResourceInfo currentResource,Class<T> type) throws Exception {
        super(currentResource);
        if (this.CurrentResource != null && !StringExtension.IsNullOrEmpty(this.CurrentResource.Meta))
        {
            currentResource.setMetaObj(type);
            this.Meta = currentResource.getMetaObj();
            this.Verify(currentResource);
        }
    }
    public T Meta;
}
