package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.Utility;
import LinkFuture.Init.Config;
import LinkFuture.Init.ObjectExtend.NameValuePair;
import LinkFuture.Init.ObjectExtend.XsltInfo;

import java.util.ArrayList;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public class XsltContentProcessor extends ContentBeanBaseProcessor<XsltContentProcessorMetaInfo> {
    public XsltContentProcessor(ContentItemInfo content, ProcessorInfo currentProcessor) throws Exception {
        super(content, currentProcessor,XsltContentProcessorMetaInfo.class);
    }
    private XsltInfo ReadXslt(ContentParameterCollectionInfo parameters) throws Exception {
        String xsltPath = parameters.ParamReplace(this.Meta.XsltUri);
        return Utility.XsltReader(xsltPath);
    }
    @Override
    public void Transformer(ContentResultCollectionInfo resourceList, ContentParameterCollectionInfo parameters) throws Exception {
        XsltInfo xsltInfo = this.ReadXslt(parameters);
        ArrayList<NameValuePair> argumentsList = new ArrayList<>();
        for(String myParam:xsltInfo.ParameterList)
        {
             if(parameters.containsKey(myParam))
             {
                 Object myParamValue = parameters.get(myParam);
                 if(myParamValue!=null)
                 {
                     argumentsList.add(new NameValuePair(myParam,parameters.get(myParam)));
                 }
             }
        }

        ContentResultInfo output = new ContentResultInfo();
        output.ResultType = ContentResultType.Xml;
        output.Success = true;
        output.Result = Utility.xsltTransformer(resourceList.ToContentXml(), xsltInfo.XsltContent, xsltInfo.XsltFilePath, argumentsList.toArray(new NameValuePair[argumentsList.size()]));;
        resourceList.clear();
        resourceList.put("$XsltContentProcessor$" + System.currentTimeMillis(), output);
    }

    @Override
    public String BuildProcessorIdentity(ContentParameterCollectionInfo parameters) throws Exception {
        XsltInfo xsltInfo = this.ReadXslt(parameters);
        StringBuilder sb = new StringBuilder();
        sb.append("$XsltContentProcessor$");
        for(String myParam:xsltInfo.ParameterList)
        {
            sb.append(String.format("%s:%s", myParam, parameters.containsKey(myParam) ? parameters.get(myParam) : Config.Empty));
        }
        return sb.toString();
    }

    @Override
    public void Verify(ProcessorInfo currentProcessor) throws Exception {

    }
}
