package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.Model.ContentItemInfo;
import LinkFuture.Core.ContentManager.Model.ProcessorInfo;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBeanBaseProcessor<T> extends ContentBaseProcessor {
    public ContentBeanBaseProcessor(ContentItemInfo content, ProcessorInfo currentProcessor,Class<T> type) throws Exception {
        super(content,currentProcessor);
        if (this.CurrentProcessor != null && !StringExtension.IsNullOrEmpty(this.CurrentProcessor.Meta))
        {
            currentProcessor.setMetaObj(type);
            this.Meta = currentProcessor.getMetaObj();
            this.Verify(this.CurrentProcessor);
        }
    }
    public T Meta;
}
