package LinkFuture.Core.ContentManager.ContentProcessor;

import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public abstract class ContentBaseProcessor implements IContentProcessor {
    public ContentItemInfo ContentItem;
    public ProcessorInfo CurrentProcessor;
    private String processorIdentity;
    public ContentBaseProcessor(ContentItemInfo content, ProcessorInfo currentProcessor)
    {
        this.ContentItem = content;
        this.CurrentProcessor = currentProcessor;
    }
    public abstract void Transformer(ContentResultCollectionInfo resourceList, ContentParameterCollectionInfo parameters) throws Exception;
    public String GerProcessorIdentity(ContentParameterCollectionInfo parameters) throws Exception
    {
        if(StringExtension.IsNullOrEmpty(processorIdentity))
        {
            this.processorIdentity = BuildProcessorIdentity(parameters);
        }
        return this.processorIdentity;
    }
    public abstract String BuildProcessorIdentity(ContentParameterCollectionInfo parameters) throws Exception;
    public abstract void Verify(ProcessorInfo currentProcessor) throws Exception;

    @Override
    public boolean MatchCondition(ContentItemInfo content, ContentParameterCollectionInfo parameters) {
        AddInfo add;
        if(content!=null)
        {
            add = content.FindProcessorAddInfo(this.CurrentProcessor.Name);
            if(add!=null && !StringExtension.IsNullOrEmpty(add.Condition))
            {
                Debugger.LogFactory.trace("MatchCondition:{}",add.Condition);
                return LinkFuture.Core.Utility.stringExpression(parameters, add.Condition);
            }
        }
        return true;
    }
}
