package LinkFuture.Core.ContentManager;

import LinkFuture.Core.ActivatorsStorage;
import LinkFuture.Core.ContentManager.ContentAction.ContentActionInfo;
import LinkFuture.Core.ContentManager.ContentAction.ContentBaseAction;
import LinkFuture.Core.ContentManager.ContentParameter.IContentParameter;
import LinkFuture.Core.ContentManager.ContentResource.IContentResource;
import LinkFuture.Core.ContentManager.Model.*;
import LinkFuture.Core.JsonManager.JsonOptionInfo;
import LinkFuture.Core.Utility;
import LinkFuture.Init.ConfigurationManager.ConfigurationController;
import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.PathExtension;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Init.ObjectExtend.CaseInsensitiveMap;
import LinkFuture.Init.ObjectExtend.NameValuePair;

import java.util.ArrayList;
import java.util.Collection;

/**
 * User: Cyokin Zhang
 * Date: 10/1/13
 * Time: 10:48 AM
 */
public class ContentController {
    public final static ContentConfigurationInfo ContentConfigurationMeta = Read();

    //region LoadResource
    public static Object LoadResource(String resourceName) throws Exception {
        return LoadResource(resourceName,null);
    }
    public static Object LoadResource(String resourceName,Collection<NameValuePair> args) throws Exception {
        ArrayList<NameValuePair> inputList  = BuildParameters(args);

        ResourceInfo resource = FindResource(resourceName);
        IContentResource realAction = ActivatorsStorage.GetActivator(resource.Type, resource);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        for (NameValuePair item:inputList)
        {
            list.put(item.id,item.value);
        }
        return realAction.GerResource(null,list);
    }
    //endregion

    //region LoadContent
    public static ContentResultCollectionInfo LoadContent(String resourceName) throws Exception {
        return LoadContent(resourceName, null);
    }
    public static ContentResultCollectionInfo LoadContent(String resourceName,Collection<NameValuePair> args) throws Exception {
        return LoadContent(resourceName, args, false);
    }
    public static ContentResultCollectionInfo LoadContent(String contentName, Collection<NameValuePair> args, boolean resourceOnly) throws Exception {
        ArrayList<NameValuePair> inputList  = BuildParameters(args);
        ContentActionInfo meta = new ContentActionInfo(ContentController.FindContentItem(contentName),inputList);
        meta.ResourceOnly = resourceOnly;
        ContentBaseAction action = new ContentBaseAction(meta);
        return action.Action();
    }

    //endregion

    //region LoadContent for XSLT extension
    public static String LoadContent(String resourceName,String paramKey1,String paramValue1) throws Exception {

        return LoadContentWithParam(resourceName,paramKey1,paramValue1);
    }
    public static String LoadContent(String resourceName,String paramKey1,String paramValue1,String paramKey2,String paramValue2) throws Exception {

        return LoadContentWithParam(resourceName,paramKey1,paramValue1,paramKey2,paramValue2);
    }
    public static String LoadContent(String resourceName,String paramKey1,String paramValue1,String paramKey2,String paramValue2,String paramKey3,String paramValue3) throws Exception {

        return LoadContentWithParam(resourceName,paramKey1,paramValue1,paramKey2,paramValue2,paramKey3,paramValue3);
    }
    public static String LoadContent(String resourceName,String paramKey1,String paramValue1,String paramKey2,String paramValue2,String paramKey3,String paramValue3,String paramKey4,String paramValue4) throws Exception {

        return LoadContentWithParam(resourceName,paramKey1,paramValue1,paramKey2,paramValue2,paramKey3,paramValue3,paramKey4,paramValue4);
    }
    public static String LoadContentWithParam(String resourceName,String ... args) throws Exception {
        if(args==null || args.length==0)
        {
            ContentResultCollectionInfo result = LoadContent(resourceName);
            result.Params.clear();
            return result.ToContentXml();
        }
        Collection<NameValuePair> list = new ArrayList<>();
        for (int i=0;i<args.length;i=i+2)
        {
            list.add(new NameValuePair(args[i],args[i+1]));
        }
        ContentResultCollectionInfo result = LoadContent(resourceName,list);
        result.Params.clear();
        return result.ToContentXml();
    }
    //endregion

    //region LoadParameters
    public static CaseInsensitiveMap<Object> LoadParameters(String paramName) throws Exception {
        return LoadParameters(paramName, null);
    }
    public static CaseInsensitiveMap<Object> LoadParameters(String paramName,Collection<NameValuePair> args) throws Exception {
        if(args==null) args = new ArrayList<>();
        ParameterInfo parameter = FindParameter(paramName);
        ContentParameterCollectionInfo list = new ContentParameterCollectionInfo();
        //user param always go first
        for (NameValuePair item:args)
        {
            list.put(item.id,item.value);
        }
        IContentParameter realAction = ActivatorsStorage.GetActivator(parameter.Type, parameter);
        return realAction.GerParameter(list);
    }
    //endregion

    private static ArrayList<NameValuePair> BuildParameters(Collection<NameValuePair> args){
        //must rebuild, can't use input list directly;
        ArrayList<NameValuePair> output = new ArrayList<>();
        if(args!=null)
        {
            for (NameValuePair item :args)
            {
                output.add(item);
            }
        }
        output.add(new NameValuePair("LF_APPPath",PathExtension.getApplicationPath()));
        return output;
    }

    //region find
    public static ResourceInfo FindResource(String name)  {
        if(ContentConfigurationMeta.ResourceList!=null && ContentConfigurationMeta.ResourceList.containsKey(name))
        {
            return ContentConfigurationMeta.ResourceList.get(name);
        }
        throw new IllegalArgumentException("Specific resource not found:" + name);
    }
    public static ParameterInfo FindParameter(String name)  {
        if(ContentConfigurationMeta.ParameterList!=null && ContentConfigurationMeta.ParameterList.containsKey(name))
        {
            return ContentConfigurationMeta.ParameterList.get(name);
        }
        throw new IllegalArgumentException("Specific parameter not found:" + name);
    }
    public static ContentItemInfo FindContentItem(String name)  {
        if(ContentConfigurationMeta.ContentItemList!=null && ContentConfigurationMeta.ContentItemList.containsKey(name))
        {
            return ContentConfigurationMeta.ContentItemList.get(name);
        }
        throw new IllegalArgumentException("Specific content item not found:" + name);
    }
    //endregion

    private synchronized static ContentConfigurationInfo Read() {
        try {
            String contentSettingPath =  PathExtension.getConfigFilePath(ConfigurationController.AppSettings("ContentSettingPath"));
            ContentConfigurationInfo config = Utility.fromXml(LinkFuture.Init.Utility.getStringFromFile(contentSettingPath), ContentConfigurationInfo.class);
            //verify configuration
            if (config.ResourceList != null)
            {
                for(ResourceInfo item:config.ResourceList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific resource type on:" + item.Name);
                    }
                    //active test and verify if the type is exist!
                    //ActivatorsStorage.VerifyClass(item.Type);
                    //active to verify type, and parse xml meta if have
                    item.getContentResource();
                }
            }
            if (config.ParameterList != null)
            {
                for(ParameterInfo item:config.ParameterList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific parameter type on:" + item.Name);
                    }
                    //active test and verify if the type is exist!
                    //ActivatorsStorage.VerifyClass(item.Type);
                    //active to verify type, and parse xml meta if have
                    item.getContentParameter();
                }
            }
            if (config.ProcessorList != null)
            {
                for(ProcessorInfo item:config.ProcessorList.values())
                {
                    if (StringExtension.IsNullOrEmpty(item.Type))
                    {
                        throw new IllegalArgumentException("Please specific processor type on:" + item.Name);
                    }
                    //active to verify type, and parse xml meta if have
                    item.getContentProcessor(null);
                    //ActivatorsStorage.VerifyClass(item.Type);
                }
            }
            if (config.ContentItemList != null)
            {
                for(ContentItemInfo content:config.ContentItemList.values())
                {
                    //use default json option
                    if(content.JsonOption == null)
                    {
                        content.JsonOption = new JsonOptionInfo();
                        content.JsonOption.AttributePrefix = "";
                        content.JsonOption.CDataNodeName = "Content";
                        content.JsonOption.IgnoreNamespace = true;
                    }
                    if(content.ValidatorList!=null)
                    {
                        for(ValidatorInfo validator:content.ValidatorList)
                        {
                            if (StringExtension.IsNullOrEmpty(validator.Type))
                            {
                                throw new IllegalArgumentException("Please specific validator type on:" + content.Name);
                            }
                            //active test and verify if the type is exist!
                            validator.getContentValidator(content);
                            //ActivatorsStorage.VerifyClass(validator.Type);
                        }
                    }
                    //reset resource object from config.ResourceList, and build sequence
                    if (config.ResourceList!=null && content.ResourceList!=null)
                    {
                        //find max sequence
                        int max = 0;
                        for (AddInfo add:content.ResourceList)
                        {
                             if(max < add.Sequence)
                             {
                                 max = add.Sequence;
                             }
                             if(add.SelectorList!=null)
                             {
                                 //set default cycle is Before
                                 for (AddParameterInfo selector :add.SelectorList.values())
                                 {
                                     if(selector.Cycle==null)
                                     {
                                         selector.Cycle = AddCycleType.Before;
                                     }
                                 }
                             }
                        }
                        //build temp
                        ArrayList<ResourceInfo>[] cachedResourceListTemp = new ArrayList[max + 1];
                        for (AddInfo add:content.ResourceList)
                        {
                            if (!config.ResourceList.containsKey(add.Name))
                            {
                                throw new IllegalArgumentException("Specific resource type not exist:" + add.Name);
                            }
                            else
                            {
                                if(cachedResourceListTemp[add.Sequence]==null)
                                {
                                    cachedResourceListTemp[add.Sequence] = new ArrayList<>();
                                }
                                cachedResourceListTemp[add.Sequence].add(config.ResourceList.get(add.Name));
                            }
                        }
                        //build CachedResourceList
                        content.CachedResourceList = new ArrayList<>();
                        for (ArrayList<ResourceInfo> itemList:cachedResourceListTemp)
                        {
                             if(itemList!=null)
                             {
                                 content.CachedResourceList.add(itemList);
                             }
                        }
                    }
                    //reset parameter object from config.ParameterList;
                    if (config.ParameterList!=null)
                    {
                        content.CachedParameterList = new ArrayList<>();
                        if(content.ParameterList!=null)
                        {
                            for (AddInfo add:content.ParameterList)
                            {

                                if (!config.ParameterList.containsKey(add.Name))
                                {
                                    throw new IllegalArgumentException("Specific parameter type not exist:" + add.Name);
                                }
                                else
                                {
                                    ParameterInfo myParameter = config.ParameterList.get(add.Name);
                                    //we will add global param as default,
                                    if(!myParameter.Global)
                                    {
                                        content.CachedParameterList.add(myParameter);
                                    }
                                }
                            }
                        }
                        //append global parameter
                        for (ParameterInfo globalParameter:config.ParameterList.values())
                        {
                            if(globalParameter.Global)
                            {
                                content.CachedParameterList.add(globalParameter);
                            }
                        }
                    }
                    if (config.ProcessorList!=null && content.ProcessorList!=null)
                    {
                        content.CachedProcessorList = new ArrayList<>();
                        for (AddInfo processor:content.ProcessorList)
                        {
                            if (!config.ProcessorList.containsKey(processor.Name))
                            {
                                throw new IllegalArgumentException("Specific processor type not exist:" + processor.Name);
                            }
                            else
                            {
                                content.CachedProcessorList.add(config.ProcessorList.get(processor.Name));
                            }
                        }
                    }
                }
            }
            return config;
        }
        catch (Exception ex)
        {
            Debugger.LogFactory.error("Init content manager failed",ex);
            throw new RuntimeException("Init content manager failed, due to ", ex);
        }
    }
}
