package LinkFuture.Core;

import LinkFuture.Init.Debugger;
import LinkFuture.Init.Extensions.StringExtension;
import LinkFuture.Core.MemoryManager.StaticMemoryCache.StaticMemoryCacheHelper;
import LinkFuture.Core.OperationManager.Operation;

import java.lang.reflect.Constructor;


/**
 * LinkFuture.
 * User: Cyokin Zhang
 * Date: 10/12/13
 * Time: 9:56 PM
 */
public class ActivatorsStorage {
    public static<T> T GetActivator(String typeString,Object...args) throws Exception {
        VerifyClass(typeString);
        return (T)((Constructor) StaticMemoryCacheHelper.GetNeverExpiredMemoryCache(getUniqueKey(typeString))).newInstance(args);
    }

    public static void VerifyClass(String typeString) throws Exception {
        if(StringExtension.IsNullOrEmpty(typeString))
        {
            throw new IllegalArgumentException("type name can't not be null.");
        }
        String key = getUniqueKey(typeString);
        StaticMemoryCacheHelper.AddNeverExpiredMemoryCache(key, new Operation<Object>(typeString) {
            @Override
            public Object call() throws Exception {
                String className = (String) this.params[0];
                Debugger.LogFactory.trace("Activating class {}", className);
                //Class myClass = Class.forName(typeString,true,ClassLoader.getSystemClassLoader());
                Class myClass = Class.forName(className);
                Constructor[] cst = myClass.getConstructors();
                if (cst.length <= 0) {
                    throw new IllegalArgumentException("Can't init %s type, as it don't have default constructor.");
                }
                return cst[0];
            }
        });
    }
    private static String getUniqueKey(String typeString)
    {
        return  "$ActivatorsStorage$_".concat(typeString);
    }
}
