/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.db;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.SqlDbStartupHook;
import com.networknt.kafka.common.AvroConverter;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.security.KeyUtil;
import com.networknt.status.Status;
import com.networknt.utility.HashUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import net.lightapi.portal.market.ConfigCreatedEvent;
import net.lightapi.portal.market.ConfigDeletedEvent;
import net.lightapi.portal.market.ConfigUpdatedEvent;
import net.lightapi.portal.market.MarketClientCreatedEvent;
import net.lightapi.portal.market.MarketClientDeletedEvent;
import net.lightapi.portal.market.MarketClientUpdatedEvent;
import net.lightapi.portal.market.MarketCodeCreatedEvent;
import net.lightapi.portal.market.MarketCodeDeletedEvent;
import net.lightapi.portal.market.MarketServiceCreatedEvent;
import net.lightapi.portal.market.MarketServiceDeletedEvent;
import net.lightapi.portal.market.MarketServiceUpdatedEvent;
import net.lightapi.portal.user.HostCreatedEvent;
import net.lightapi.portal.user.HostDeletedEvent;
import net.lightapi.portal.user.HostUpdatedEvent;
import net.lightapi.portal.user.OrderCancelledEvent;
import net.lightapi.portal.user.OrderCreatedEvent;
import net.lightapi.portal.user.OrderDeliveredEvent;
import net.lightapi.portal.user.PasswordChangedEvent;
import net.lightapi.portal.user.PasswordForgotEvent;
import net.lightapi.portal.user.PasswordResetEvent;
import net.lightapi.portal.user.PaymentDeletedEvent;
import net.lightapi.portal.user.PaymentUpdatedEvent;
import net.lightapi.portal.user.PrivateMessageSentEvent;
import net.lightapi.portal.user.SocialUserCreatedEvent;
import net.lightapi.portal.user.UserConfirmedEvent;
import net.lightapi.portal.user.UserCreatedEvent;
import net.lightapi.portal.user.UserDeletedEvent;
import net.lightapi.portal.user.UserRolesUpdatedEvent;
import net.lightapi.portal.user.UserUpdatedEvent;
import org.apache.avro.specific.SpecificRecord;

public class PortalDbProviderImpl
implements PortalDbProvider {
    public static final String AUTH_CODE_CACHE = "auth_code";
    public static final String SQL_EXCEPTION = "ERR10017";
    public static final String GENERIC_EXCEPTION = "ERR10014";
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static final String INSERT_NOTIFICATION = "INSERT INTO notification_t (email, nonce, event_json, process_time, process_flag, error) VALUES (?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_NONCE = "UPDATE user_t SET nonce = ? WHERE email = ?";

    @Override
    public Result<String> queryUserByEmail(String email) {
        Result result = null;
        String sql = "SELECT host, user_id, first_name, last_name, email, roles, language, gender, birthday, taiji_wallet, country, province, city, post_code, address, verified, token, locked, password, nonce FROM user_t WHERE email = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, email);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host", resultSet.getString("host"));
                        map.put("userId", resultSet.getString("user_id"));
                        map.put("firstName", resultSet.getString("first_name"));
                        map.put("lastName", resultSet.getString("last_name"));
                        map.put("email", resultSet.getString("email"));
                        map.put("password", resultSet.getString("password"));
                        map.put("language", resultSet.getString("language"));
                        map.put("gender", resultSet.getString("gender"));
                        map.put("birthday", resultSet.getDate("birthday"));
                        map.put("taijiWallet", resultSet.getString("taiji_wallet"));
                        map.put("country", resultSet.getString("country"));
                        map.put("province", resultSet.getString("province"));
                        map.put("city", resultSet.getString("city"));
                        map.put("postCode", resultSet.getString("post_code"));
                        map.put("address", resultSet.getString("address"));
                        map.put("verified", resultSet.getBoolean("verified"));
                        map.put("token", resultSet.getString("token"));
                        map.put("locked", resultSet.getBoolean("locked"));
                        map.put("nonce", resultSet.getLong("nonce"));
                        map.put("roles", resultSet.getString("roles"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"user", email})) : Success.of((Object)JsonMapper.toJson(map));
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<String> queryUserById(String userId) {
        Result result = null;
        String sql = "SELECT host, user_id, first_name, last_name, email, roles, language, gender, birthday, taiji_wallet, country, province, city, post_code, address, verified, token, locked FROM user_t WHERE user_id = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, userId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host", resultSet.getInt("host"));
                        map.put("userId", resultSet.getString("user_id"));
                        map.put("firstName", resultSet.getInt("first_name"));
                        map.put("lastName", resultSet.getString("last_name"));
                        map.put("email", resultSet.getString("email"));
                        map.put("roles", resultSet.getString("roles"));
                        map.put("language", resultSet.getString("language"));
                        map.put("gender", resultSet.getString("gender"));
                        map.put("birthday", resultSet.getString("birthday"));
                        map.put("taijiWallet", resultSet.getString("taiji_wallet"));
                        map.put("country", resultSet.getString("country"));
                        map.put("province", resultSet.getString("province"));
                        map.put("city", resultSet.getString("city"));
                        map.put("postCode", resultSet.getString("post_code"));
                        map.put("address", resultSet.getString("address"));
                        map.put("verified", resultSet.getBoolean("verified"));
                        map.put("token", resultSet.getString("token"));
                        map.put("locked", resultSet.getBoolean("locked"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"user", userId})) : Success.of((Object)JsonMapper.toJson(map));
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<String> queryUserByWallet(String wallet) {
        Result result = null;
        String sql = "SELECT host, user_id, first_name, last_name, email, roles, language, gender, birthday, taiji_wallet, country, province, city, post_code, address, verified, token, locked FROM user_t WHERE taiji_wallet = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, wallet);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host", resultSet.getInt("host"));
                        map.put("userId", resultSet.getString("user_id"));
                        map.put("firstName", resultSet.getInt("first_name"));
                        map.put("lastName", resultSet.getString("last_name"));
                        map.put("email", resultSet.getString("email"));
                        map.put("roles", resultSet.getString("roles"));
                        map.put("language", resultSet.getString("language"));
                        map.put("gender", resultSet.getString("gender"));
                        map.put("birthday", resultSet.getString("birthday"));
                        map.put("taijiWallet", resultSet.getString("taiji_wallet"));
                        map.put("country", resultSet.getString("country"));
                        map.put("province", resultSet.getString("province"));
                        map.put("city", resultSet.getString("city"));
                        map.put("postCode", resultSet.getString("post_code"));
                        map.put("address", resultSet.getString("address"));
                        map.put("verified", resultSet.getBoolean("verified"));
                        map.put("token", resultSet.getString("token"));
                        map.put("locked", resultSet.getBoolean("locked"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"user", wallet})) : Success.of((Object)JsonMapper.toJson(map));
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<String> queryEmailByWallet(String wallet) {
        Result result = null;
        String sql = "SELECT email FROM user_t WHERE taiji_wallet = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            String email = null;
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, wallet);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        email = resultSet.getString("email");
                    }
                }
            }
            result = email == null ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"user email", wallet})) : Success.of((Object)email);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    public void insertNotification(Connection conn, String email, long nonce, String json, boolean flag, String error) throws SQLException {
        try (PreparedStatement statement = conn.prepareStatement(INSERT_NOTIFICATION);){
            statement.setString(1, email);
            statement.setLong(2, nonce);
            statement.setString(3, json);
            statement.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            statement.setBoolean(5, flag);
            if (error != null) {
                statement.setString(6, error);
            } else {
                statement.setNull(6, 0);
            }
            statement.executeUpdate();
        }
    }

    public int updateNonce(Connection conn, long nonce, String email) throws SQLException {
        int count = 0;
        try (PreparedStatement statement = conn.prepareStatement(UPDATE_NONCE);){
            statement.setLong(1, nonce);
            statement.setString(2, email);
            count = statement.executeUpdate();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createUser(UserCreatedEvent event) {
        String queryIdEmailWallet = "SELECT nonce FROM user_t WHERE user_id = ? OR email = ? OR taiji_wallet = ?";
        String queryIdEmail = "SELECT nonce FROM user_t WHERE user_id = ? OR email = ?";
        String insertUser = "INSERT INTO user_t (host, user_id, first_name, last_name, email, roles, language, verified, token, gender, password, birthday, country, province, city, post_code, address) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?)";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            PreparedStatement statement;
            block81: {
                ResultSet resultSet;
                conn = SqlDbStartupHook.ds.getConnection();
                conn.setAutoCommit(false);
                if (event.getTaijiWallet() != null) {
                    statement = conn.prepareStatement("SELECT nonce FROM user_t WHERE user_id = ? OR email = ? OR taiji_wallet = ?");
                    try {
                        statement.setString(1, event.getUserId());
                        statement.setString(2, event.getEmail());
                        statement.setString(3, event.getTaijiWallet());
                        resultSet = statement.executeQuery();
                        try {
                            if (resultSet.next()) {
                                this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "userId or email or wallet already exists in database.");
                                Result result2 = result;
                                return result2;
                            }
                            break block81;
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                statement = conn.prepareStatement("SELECT nonce FROM user_t WHERE user_id = ? OR email = ?");
                try {
                    statement.setString(1, event.getUserId());
                    statement.setString(2, event.getEmail());
                    resultSet = statement.executeQuery();
                    try {
                        if (resultSet.next()) {
                            this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "userId or email already exists in database.");
                            Result result3 = result;
                            return result3;
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            statement = conn.prepareStatement("INSERT INTO user_t (host, user_id, first_name, last_name, email, roles, language, verified, token, gender, password, birthday, country, province, city, post_code, address) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?)");
            try {
                statement.setString(1, event.getHost());
                statement.setString(2, event.getUserId());
                if (map.get("first_name") != null) {
                    statement.setString(3, (String)map.get("first_name"));
                } else {
                    statement.setNull(3, 0);
                }
                if (map.get("last_name") != null) {
                    statement.setString(4, (String)map.get("last_name"));
                } else {
                    statement.setNull(4, 0);
                }
                statement.setString(5, event.getEmail());
                statement.setString(6, event.getRoles());
                statement.setString(7, event.getLanguage());
                statement.setBoolean(8, event.getVerified());
                statement.setString(9, event.getToken());
                if (map.get("gender") != null) {
                    statement.setString(10, (String)map.get("gender"));
                } else {
                    statement.setNull(10, 0);
                }
                statement.setString(11, event.getPassword());
                java.util.Date birthday = (java.util.Date)map.get("birthday");
                if (birthday != null) {
                    statement.setDate(12, new Date(birthday.getTime()));
                } else {
                    statement.setNull(12, 0);
                }
                Object countryObject = event.get("country");
                if (countryObject != null) {
                    statement.setString(13, (String)countryObject);
                } else {
                    statement.setNull(13, 0);
                }
                Object provinceObject = event.get("province");
                if (provinceObject != null) {
                    statement.setString(14, (String)provinceObject);
                } else {
                    statement.setNull(14, 0);
                }
                Object cityObject = event.get("city");
                if (cityObject != null) {
                    statement.setString(15, (String)cityObject);
                } else {
                    statement.setNull(15, 0);
                }
                Object postCodeObject = map.get("post_code");
                if (postCodeObject != null) {
                    statement.setString(16, (String)postCodeObject);
                } else {
                    statement.setNull(16, 0);
                }
                Object addressObject = map.get("address");
                if (addressObject != null) {
                    statement.setString(17, (String)addressObject);
                } else {
                    statement.setNull(17, 0);
                }
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
            conn.commit();
            result = Success.of((Object)event.getUserId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Result<Integer> queryNonceByEmail(String email) {
        Result result = null;
        String sql = "SELECT nonce FROM user_t WHERE email = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            Integer nonce = null;
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, email);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        nonce = resultSet.getInt("nonce");
                    }
                }
            }
            result = nonce == null ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"user nonce", email})) : Success.of((Object)nonce);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> confirmUser(UserConfirmedEvent event) {
        Result result;
        String queryTokenByEmail = "SELECT token FROM user_t WHERE email = ? AND token = ?";
        String updateUserByEmail = "UPDATE user_t SET token = null, verified = true, nonce = ? WHERE email = ?";
        Connection conn = null;
        try {
            block42: {
                conn = SqlDbStartupHook.ds.getConnection();
                conn.setAutoCommit(false);
                try (PreparedStatement statement = conn.prepareStatement("SELECT token FROM user_t WHERE email = ? AND token = ?");){
                    statement.setString(1, event.getEventId().getId());
                    statement.setString(2, event.getToken());
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (resultSet.next()) {
                            try (PreparedStatement updateStatement = conn.prepareStatement("UPDATE user_t SET token = null, verified = true, nonce = ? WHERE email = ?");){
                                updateStatement.setLong(1, event.getEventId().getNonce() + 1L);
                                updateStatement.setString(2, event.getEventId().getId());
                                updateStatement.execute();
                            }
                            this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                            break block42;
                        }
                        this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "token " + event.getToken() + " is not matched for email " + event.getEventId().getId());
                    }
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createSocialUser(SocialUserCreatedEvent event) {
        String queryIdEmail = "SELECT nonce FROM user_t WHERE user_id = ? OR email = ?";
        String insertUser = "INSERT INTO user_t (host, user_id, first_name, last_name, email, roles, language, verified, gender, birthday, country, province, city, post_code, address) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?)";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("SELECT nonce FROM user_t WHERE user_id = ? OR email = ?");){
                statement.setString(1, event.getUserId());
                statement.setString(2, event.getEmail());
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "userId or email already exists in database.");
                        Result result2 = result;
                        return result2;
                    }
                }
            }
            statement = conn.prepareStatement("INSERT INTO user_t (host, user_id, first_name, last_name, email, roles, language, verified, gender, birthday, country, province, city, post_code, address) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?)");
            try {
                statement.setString(1, event.getHost());
                statement.setString(2, event.getUserId());
                if (map.get("first_name") != null) {
                    statement.setString(3, (String)map.get("first_name"));
                } else {
                    statement.setNull(3, 0);
                }
                if (map.get("last_name") != null) {
                    statement.setString(4, (String)map.get("last_name"));
                } else {
                    statement.setNull(4, 0);
                }
                statement.setString(5, event.getEmail());
                statement.setString(6, event.getRoles());
                statement.setString(7, event.getLanguage());
                statement.setBoolean(8, event.getVerified());
                if (map.get("gender") != null) {
                    statement.setString(9, (String)map.get("gender"));
                } else {
                    statement.setNull(9, 0);
                }
                java.util.Date birthday = (java.util.Date)map.get("birthday");
                if (birthday != null) {
                    statement.setDate(10, new Date(birthday.getTime()));
                } else {
                    statement.setNull(10, 0);
                }
                Object countryObject = map.get("country");
                if (countryObject != null) {
                    statement.setString(11, (String)countryObject);
                } else {
                    statement.setNull(11, 0);
                }
                Object provinceObject = map.get("province");
                if (provinceObject != null) {
                    statement.setString(12, (String)provinceObject);
                } else {
                    statement.setNull(12, 0);
                }
                Object cityObject = map.get("city");
                if (cityObject != null) {
                    statement.setString(13, (String)cityObject);
                } else {
                    statement.setNull(13, 0);
                }
                Object postCodeObject = map.get("post_code");
                if (postCodeObject != null) {
                    statement.setString(14, (String)postCodeObject);
                } else {
                    statement.setNull(14, 0);
                }
                Object addressObject = map.get("address");
                if (addressObject != null) {
                    statement.setString(15, (String)addressObject);
                } else {
                    statement.setNull(15, 0);
                }
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
            conn.commit();
            result = Success.of((Object)event.getUserId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateUser(UserUpdatedEvent event) {
        String queryUserIdByWallet = "SELECT user_id FROM user_t WHERE taiji_wallet = ?";
        String updateUser = "UPDATE user_t SET host = ?, language = ?, taiji_wallet = ?, country = ?, province = ?, city = ?, post_code = ?, address = ?, first_name = ?, last_name = ?, gender = ?, birthday = ?, nonce = ? WHERE email = ?";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            PreparedStatement statement;
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            if (event.getTaijiWallet() != null) {
                statement = conn.prepareStatement("SELECT user_id FROM user_t WHERE taiji_wallet = ?");
                try {
                    statement.setString(1, event.getTaijiWallet());
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (resultSet.next()) {
                            String userId = resultSet.getString(1);
                            this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "wallet already exists in database for userId ." + userId);
                            Result result2 = result;
                            return result2;
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            statement = conn.prepareStatement("UPDATE user_t SET host = ?, language = ?, taiji_wallet = ?, country = ?, province = ?, city = ?, post_code = ?, address = ?, first_name = ?, last_name = ?, gender = ?, birthday = ?, nonce = ? WHERE email = ?");
            try {
                statement.setString(1, event.getHost());
                statement.setString(2, event.getLanguage());
                if (event.getTaijiWallet() != null) {
                    statement.setString(3, event.getTaijiWallet());
                } else {
                    statement.setNull(3, 0);
                }
                if (event.get("country") != null) {
                    statement.setString(4, (String)event.get("country"));
                } else {
                    statement.setNull(4, 0);
                }
                if (event.get("province") != null) {
                    statement.setString(5, (String)event.get("province"));
                } else {
                    statement.setNull(5, 0);
                }
                if (event.get("city") != null) {
                    statement.setString(6, (String)event.get("city"));
                } else {
                    statement.setNull(6, 0);
                }
                if (map.get("post_code") != null) {
                    statement.setString(7, (String)map.get("post_code"));
                } else {
                    statement.setNull(7, 0);
                }
                if (map.get("address") != null) {
                    statement.setString(8, (String)map.get("address"));
                } else {
                    statement.setNull(8, 0);
                }
                if (map.get("first_name") != null) {
                    statement.setString(9, (String)map.get("first_name"));
                } else {
                    statement.setNull(9, 0);
                }
                if (map.get("last_name") != null) {
                    statement.setString(10, (String)map.get("last_name"));
                } else {
                    statement.setNull(10, 0);
                }
                if (map.get("gender") != null) {
                    statement.setString(11, (String)map.get("gender"));
                } else {
                    statement.setNull(11, 0);
                }
                java.util.Date birthday = (java.util.Date)map.get("birthday");
                if (birthday != null) {
                    statement.setDate(12, new Date(birthday.getTime()));
                } else {
                    statement.setNull(12, 0);
                }
                statement.setString(13, event.getEmail());
                statement.setLong(14, event.getEventId().getNonce() + 1L);
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is updated by email" + event.getEmail());
                    Result result3 = result;
                    return result3;
                }
                this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            conn.commit();
            result = Success.of((Object)event.getUserId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> deleteUser(UserDeletedEvent event) {
        Result result;
        String deleteUserByEmail = "DELETE from user_t WHERE email = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("DELETE from user_t WHERE email = ?");){
                statement.setString(1, event.getEmail());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is deleted by email " + event.getEmail());
                } else {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateUserRoles(UserRolesUpdatedEvent event) {
        Result result;
        String deleteUserByEmail = "UPDATE user_t SET roles = ?, nonce = ? WHERE email = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE user_t SET roles = ?, nonce = ? WHERE email = ?");){
                statement.setString(1, event.getRoles());
                statement.setLong(2, event.getEventId().getNonce() + 1L);
                statement.setString(3, event.getEmail());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no roles is updated by email " + event.getEmail());
                } else {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> forgetPassword(PasswordForgotEvent event) {
        Result result;
        String deleteUserByEmail = "UPDATE user_t SET token = ?, nonce = ? WHERE email = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE user_t SET token = ?, nonce = ? WHERE email = ?");){
                statement.setString(1, event.getToken());
                statement.setLong(2, event.getEventId().getNonce() + 1L);
                statement.setString(3, event.getEmail());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no token is updated by email " + event.getEmail());
                } else {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> resetPassword(PasswordResetEvent event) {
        Result result;
        String deleteUserByEmail = "UPDATE user_t SET token = ?, nonce = ? WHERE email = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE user_t SET token = ?, nonce = ? WHERE email = ?");){
                statement.setString(1, event.getToken());
                statement.setLong(2, event.getEventId().getNonce() + 1L);
                statement.setString(3, event.getEmail());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no token is updated by email " + event.getEmail());
                } else {
                    this.insertNotification(conn, event.getEmail(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> changePassword(PasswordChangedEvent event) {
        Result result;
        String updatePasswordByEmail = "UPDATE user_t SET password = ?, nonce = ? WHERE email = ? AND password = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE user_t SET password = ?, nonce = ? WHERE email = ? AND password = ?");){
                statement.setString(1, event.getPassword());
                statement.setLong(2, event.getEventId().getNonce() + 1L);
                statement.setString(3, event.getEventId().getId());
                statement.setString(4, event.getOldPassword());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no password is updated by email " + event.getEventId().getId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Result<String> updatePayment(PaymentUpdatedEvent event) {
        return null;
    }

    @Override
    public Result<String> deletePayment(PaymentDeletedEvent event) {
        return null;
    }

    @Override
    public Result<String> createOrder(OrderCreatedEvent event) {
        return null;
    }

    @Override
    public Result<String> cancelOrder(OrderCancelledEvent event) {
        return null;
    }

    @Override
    public Result<String> deliverOrder(OrderDeliveredEvent event) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> sendPrivateMessage(PrivateMessageSentEvent event) {
        Result result;
        String insertMessage = "INSERT INTO message_t (from_id, nonce, to_email, subject, content, send_time) VALUES (?, ?, ?, ?, ?, ?)";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            int count = this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            if (count == 0) {
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no nonce is updated by email " + event.getEventId().getId());
            } else {
                try (PreparedStatement statement = conn.prepareStatement("INSERT INTO message_t (from_id, nonce, to_email, subject, content, send_time) VALUES (?, ?, ?, ?, ?, ?)");){
                    statement.setString(1, event.getFromId());
                    statement.setLong(2, event.getEventId().getNonce());
                    statement.setString(3, event.getToEmail());
                    statement.setString(4, event.getSubject());
                    statement.setString(5, event.getContent());
                    statement.setTimestamp(6, new Timestamp(event.getTimestamp()));
                    statement.executeUpdate();
                }
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
            }
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createClient(MarketClientCreatedEvent event) {
        String insertUser = "INSERT INTO application_t (host, application_id, application_name, application_description, is_kafka_application, client_id, client_type, client_profile, client_secret, client_scope, custom_claim, redirect_uri, authenticate_class, deref_client_id, operation_owner, delivery_owner, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?)";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("INSERT INTO application_t (host, application_id, application_name, application_description, is_kafka_application, client_id, client_type, client_profile, client_secret, client_scope, custom_claim, redirect_uri, authenticate_class, deref_client_id, operation_owner, delivery_owner, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?)");){
                statement.setString(1, event.getHost());
                statement.setString(2, event.getApplicationId());
                statement.setString(3, (String)map.get("applicationName"));
                if (map.get("applicationDescription") != null) {
                    statement.setString(4, (String)map.get("applicationDescription"));
                } else {
                    statement.setNull(4, 0);
                }
                if (map.get("isKafkaApplication") != null) {
                    statement.setBoolean(5, (Boolean)map.get("isKafkaApplication"));
                } else {
                    statement.setNull(5, 0);
                }
                statement.setString(6, (String)map.get("clientId"));
                statement.setString(7, (String)map.get("clientType"));
                statement.setString(8, (String)map.get("clientProfile"));
                statement.setString(9, (String)map.get("clientSecret"));
                if (map.get("clientScope") != null) {
                    statement.setString(10, (String)map.get("clientScope"));
                } else {
                    statement.setNull(10, 0);
                }
                if (map.get("customClaim") != null) {
                    statement.setString(11, (String)map.get("customClaim"));
                } else {
                    statement.setNull(11, 0);
                }
                if (map.get("redirectUri") != null) {
                    statement.setString(12, (String)map.get("redirectUri"));
                } else {
                    statement.setNull(12, 0);
                }
                if (map.get("authenticateClass") != null) {
                    statement.setString(13, (String)map.get("authenticateClass"));
                } else {
                    statement.setNull(13, 0);
                }
                if (map.get("derefClientId") != null) {
                    statement.setString(14, (String)map.get("derefClientId"));
                } else {
                    statement.setNull(14, 0);
                }
                if (map.get("operationOwner") != null) {
                    statement.setString(15, (String)map.get("operationOwner"));
                } else {
                    statement.setNull(15, 0);
                }
                if (map.get("deliveryOwner") != null) {
                    statement.setString(16, (String)map.get("deliveryOwner"));
                } else {
                    statement.setNull(16, 0);
                }
                statement.setString(17, event.getEventId().getId());
                statement.setTimestamp(18, new Timestamp(System.currentTimeMillis()));
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the application " + event.getApplicationId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getApplicationId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateClient(MarketClientUpdatedEvent event) {
        String updateApplication = "UPDATE application_t SET application_name = ?, application_description = ?, is_kafka_application = ?, client_type = ?, client_profile = ?, client_scope = ?, custom_claim = ?, redirect_uri = ?, authenticate_class = ?, deref_client_id = ?, operation_owner = ?, delivery_owner = ?, update_user = ?, update_timestamp = ? WHERE host = ? AND application_id = ?";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE application_t SET application_name = ?, application_description = ?, is_kafka_application = ?, client_type = ?, client_profile = ?, client_scope = ?, custom_claim = ?, redirect_uri = ?, authenticate_class = ?, deref_client_id = ?, operation_owner = ?, delivery_owner = ?, update_user = ?, update_timestamp = ? WHERE host = ? AND application_id = ?");){
                if (map.get("applicationName") != null) {
                    statement.setString(1, (String)map.get("applicationName"));
                } else {
                    statement.setNull(1, 0);
                }
                if (map.get("applicationDescription") != null) {
                    statement.setString(2, (String)map.get("applicationDescription"));
                } else {
                    statement.setNull(2, 0);
                }
                if (map.get("isKafkaApplication") != null) {
                    statement.setBoolean(3, (Boolean)map.get("isKafkaApplication"));
                } else {
                    statement.setNull(3, 0);
                }
                if (map.get("clientType") != null) {
                    statement.setString(4, (String)map.get("clientType"));
                } else {
                    statement.setNull(4, 0);
                }
                if (map.get("clientProfile") != null) {
                    statement.setString(5, (String)map.get("clientProfile"));
                } else {
                    statement.setNull(5, 0);
                }
                if (map.get("clientScope") != null) {
                    statement.setString(6, (String)map.get("clientScope"));
                } else {
                    statement.setNull(6, 0);
                }
                if (map.get("customClaim") != null) {
                    statement.setString(7, (String)map.get("customClaim"));
                } else {
                    statement.setNull(7, 0);
                }
                if (map.get("redirectUri") != null) {
                    statement.setString(8, (String)map.get("redirectUri"));
                } else {
                    statement.setNull(8, 0);
                }
                if (map.get("authenticateClass") != null) {
                    statement.setString(9, (String)map.get("authenticateClass"));
                } else {
                    statement.setNull(9, 0);
                }
                if (map.get("derefClientId") != null) {
                    statement.setString(10, (String)map.get("derefClientId"));
                } else {
                    statement.setNull(10, 0);
                }
                if (map.get("operationOwner") != null) {
                    statement.setString(11, (String)map.get("operationOwner"));
                } else {
                    statement.setNull(11, 0);
                }
                if (map.get("deliveryOwner") != null) {
                    statement.setString(12, (String)map.get("deliveryOwner"));
                } else {
                    statement.setNull(12, 0);
                }
                statement.setString(13, event.getEventId().getId());
                statement.setTimestamp(14, new Timestamp(System.currentTimeMillis()));
                statement.setString(15, event.getHost());
                statement.setString(16, event.getApplicationId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is updated by application" + event.getApplicationId());
                    Result result2 = result;
                    return result2;
                }
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            }
            conn.commit();
            result = Success.of((Object)event.getApplicationId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> deleteClient(MarketClientDeletedEvent event) {
        Result result;
        String deleteApplication = "DELETE from application_t WHERE host = ? AND application_id = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("DELETE from application_t WHERE host = ? AND application_id = ?");){
                statement.setString(1, event.getHost());
                statement.setString(2, event.getApplicationId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is deleted for application " + event.getApplicationId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryClientByClientId(String clientId) {
        Result result;
        String sql = "SELECT host_id, application_id, application_name, application_description, is_kafka_application, client_id, client_type, client_profile, client_secret, client_scope, custom_claim, redirect_uri, authenticate_class, deref_client_id, operation_owner, delivery_owner, update_user, update_timestamp FROM application_t WHERE client_id = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, clientId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("hostId", resultSet.getString("host_id"));
                        map.put("applicationId", resultSet.getString("application_id"));
                        map.put("applicationDescription", resultSet.getString("application_description"));
                        map.put("isKafkaApplication", resultSet.getBoolean("is_kafka_application"));
                        map.put("clientId", resultSet.getString("client_id"));
                        map.put("clientType", resultSet.getString("client_type"));
                        map.put("clientProfile", resultSet.getString("client_profile"));
                        map.put("clientSecret", resultSet.getString("client_secret"));
                        map.put("clientScope", resultSet.getString("client_scope"));
                        map.put("customClaim", resultSet.getString("custom_claim"));
                        map.put("redirectUri", resultSet.getString("redirect_uri"));
                        map.put("authenticateClass", resultSet.getString("authenticate_class"));
                        map.put("derefClientId", resultSet.getString("deref_client_id"));
                        map.put("operationOwner", resultSet.getString("operation_owner"));
                        map.put("deliveryOwner", resultSet.getString("delivery_owner"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"application with clientId ", clientId})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryClientByHostAppId(String host_id, String applicationId) {
        Result result;
        String sql = "SELECT host_id, application_id, application_name, application_description, is_kafka_application, client_id, client_type, client_profile, client_secret, client_scope, custom_claim, redirect_uri, authenticate_class, deref_client_id, operation_owner, delivery_owner, update_user, update_timestamp FROM application_t WHERE host = ? AND application_id = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, host_id);
                statement.setString(2, applicationId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("hostId", resultSet.getString("host_id"));
                        map.put("applicationIdd", resultSet.getString("application_id"));
                        map.put("applicationDescription", resultSet.getString("application_description"));
                        map.put("isKafkaApplication", resultSet.getBoolean("is_kafka_application"));
                        map.put("clientId", resultSet.getString("client_id"));
                        map.put("clientType", resultSet.getString("client_type"));
                        map.put("clientProfile", resultSet.getString("client_profile"));
                        map.put("clientSecret", resultSet.getString("client_secret"));
                        map.put("clientScope", resultSet.getString("client_scope"));
                        map.put("customClaim", resultSet.getString("custom_claim"));
                        map.put("redirectUri", resultSet.getString("redirect_uri"));
                        map.put("authenticateClass", resultSet.getString("authenticate_class"));
                        map.put("derefClientId", resultSet.getString("deref_client_id"));
                        map.put("operationOwner", resultSet.getString("operation_owner"));
                        map.put("deliveryOwner", resultSet.getString("delivery_owner"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"application with applicationId ", applicationId})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createService(MarketServiceCreatedEvent event) {
        String insertUser = "INSERT INTO api_t (host_id, api_id, api_name, service_id, api_description, operation_owner, delivery_owner, api_type_id, region_id, lob_id, platform_id, capability_id, api_marketplace_team_id, git_repository, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?)";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("INSERT INTO api_t (host_id, api_id, api_name, service_id, api_description, operation_owner, delivery_owner, api_type_id, region_id, lob_id, platform_id, capability_id, api_marketplace_team_id, git_repository, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?,   ?)");){
                statement.setString(1, event.getHost());
                statement.setString(2, event.getApiId());
                statement.setString(3, (String)map.get("apiName"));
                statement.setString(4, (String)map.get("serviceId"));
                if (map.get("apiDescription") != null) {
                    statement.setString(5, (String)map.get("applicationDescription"));
                } else {
                    statement.setNull(5, 0);
                }
                if (map.get("operationOwner") != null) {
                    statement.setString(6, (String)map.get("operationOwner"));
                } else {
                    statement.setNull(6, 0);
                }
                if (map.get("deliveryOwner") != null) {
                    statement.setString(7, (String)map.get("deliveryOwner"));
                } else {
                    statement.setNull(7, 0);
                }
                if (map.get("apiTypeId") != null) {
                    statement.setInt(8, (Integer)map.get("apiTypeId"));
                } else {
                    statement.setNull(8, 0);
                }
                if (map.get("regionId") != null) {
                    statement.setInt(9, (Integer)map.get("regionId"));
                } else {
                    statement.setNull(9, 0);
                }
                if (map.get("lobId") != null) {
                    statement.setInt(10, (Integer)map.get("lobId"));
                } else {
                    statement.setNull(10, 0);
                }
                if (map.get("platformId") != null) {
                    statement.setInt(11, (Integer)map.get("platformId"));
                } else {
                    statement.setNull(11, 0);
                }
                if (map.get("capabilityId") != null) {
                    statement.setInt(12, (Integer)map.get("capabilityId"));
                } else {
                    statement.setNull(12, 0);
                }
                if (map.get("apiMarketplaceTeamId") != null) {
                    statement.setInt(13, (Integer)map.get("apiMarketplaceTeamId"));
                } else {
                    statement.setNull(13, 0);
                }
                if (map.get("gitRepository") != null) {
                    statement.setString(14, (String)map.get("gitRepository"));
                } else {
                    statement.setNull(14, 0);
                }
                statement.setString(15, event.getEventId().getId());
                statement.setTimestamp(16, new Timestamp(System.currentTimeMillis()));
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the api " + event.getApiId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getApiId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateService(MarketServiceUpdatedEvent event) {
        String updateApi = "UPDATE api_t SET api_name = ?, service_id = ?, service_type = ?, api_description = ? operation_owner = ?, delivery_owner = ?, api_type_id = ?, region_id = ?, lob_id = ?, platform_id = ?, capability_id = ?, api_marketplace_team_id = ?, git_repository = ?, update_user = ?, update_timestamp = ? WHERE host_id = ? AND api_id = ?";
        Result result = null;
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE api_t SET api_name = ?, service_id = ?, service_type = ?, api_description = ? operation_owner = ?, delivery_owner = ?, api_type_id = ?, region_id = ?, lob_id = ?, platform_id = ?, capability_id = ?, api_marketplace_team_id = ?, git_repository = ?, update_user = ?, update_timestamp = ? WHERE host_id = ? AND api_id = ?");){
                if (map.get("apiName") != null) {
                    statement.setString(1, (String)map.get("apiName"));
                } else {
                    statement.setNull(1, 0);
                }
                if (map.get("serviceId") != null) {
                    statement.setString(2, (String)map.get("serviceId"));
                } else {
                    statement.setNull(2, 0);
                }
                if (map.get("serviceType") != null) {
                    statement.setString(3, (String)map.get("serviceType"));
                } else {
                    statement.setNull(3, 0);
                }
                if (map.get("apiDescription") != null) {
                    statement.setString(4, (String)map.get("apiDescription"));
                } else {
                    statement.setNull(4, 0);
                }
                if (map.get("operationOwner") != null) {
                    statement.setString(5, (String)map.get("operationOwner"));
                } else {
                    statement.setNull(5, 0);
                }
                if (map.get("deliveryOwner") != null) {
                    statement.setString(6, (String)map.get("deliveryOwner"));
                } else {
                    statement.setNull(6, 0);
                }
                if (map.get("apiTypeId") != null) {
                    statement.setInt(7, (Integer)map.get("apiTypeId"));
                } else {
                    statement.setNull(7, 0);
                }
                if (map.get("regionId") != null) {
                    statement.setInt(8, (Integer)map.get("regionId"));
                } else {
                    statement.setNull(8, 0);
                }
                if (map.get("lobId") != null) {
                    statement.setInt(9, (Integer)map.get("lobId"));
                } else {
                    statement.setNull(9, 0);
                }
                if (map.get("platformId") != null) {
                    statement.setInt(10, (Integer)map.get("platformId"));
                } else {
                    statement.setNull(10, 0);
                }
                if (map.get("capabilityId") != null) {
                    statement.setInt(11, (Integer)map.get("capabilityId"));
                } else {
                    statement.setNull(11, 0);
                }
                if (map.get("apiMarketplaceTeamId") != null) {
                    statement.setInt(12, (Integer)map.get("apiMarketplaceTeamId"));
                } else {
                    statement.setNull(12, 0);
                }
                if (map.get("gitRepository") != null) {
                    statement.setString(13, (String)map.get("gitRepository"));
                } else {
                    statement.setNull(13, 0);
                }
                statement.setString(14, event.getEventId().getId());
                statement.setTimestamp(15, new Timestamp(event.getTimestamp()));
                statement.setString(16, event.getHost());
                statement.setString(17, event.getApiId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is updated by api " + event.getApiId());
                    Result result2 = result;
                    return result2;
                }
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            }
            conn.commit();
            result = Success.of((Object)event.getApiId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> deleteService(MarketServiceDeletedEvent event) {
        Result result;
        String deleteApplication = "DELETE from api_t WHERE host = ? AND api_id = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("DELETE from api_t WHERE host = ? AND api_id = ?");){
                statement.setString(1, event.getHost());
                statement.setString(2, event.getApiId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is deleted for api " + event.getApiId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException:", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Result<String> createMarketCode(MarketCodeCreatedEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace("insert into the cache auth_code with key " + event.getAuthCode() + " value " + event.getValue());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("estimate the size of the cache auth_code before is " + SqlDbStartupHook.cacheManager.getSize(AUTH_CODE_CACHE));
        }
        SqlDbStartupHook.cacheManager.put(AUTH_CODE_CACHE, event.getAuthCode(), (Object)event.getValue());
        if (logger.isTraceEnabled()) {
            logger.trace("estimate the size of the cache auth_code after is " + SqlDbStartupHook.cacheManager.getSize(AUTH_CODE_CACHE));
        }
        return Success.of((Object)event.getAuthCode());
    }

    @Override
    public Result<String> deleteMarketCode(MarketCodeDeletedEvent event) {
        if (logger.isTraceEnabled()) {
            logger.trace("insert into the cache auth_code with key " + event.getAuthCode() + " value ");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("estimate the size of the cache auth_code before is " + SqlDbStartupHook.cacheManager.getSize(AUTH_CODE_CACHE));
        }
        SqlDbStartupHook.cacheManager.delete(AUTH_CODE_CACHE, event.getAuthCode());
        if (logger.isTraceEnabled()) {
            logger.trace("estimate the size of the cache auth_code after is " + SqlDbStartupHook.cacheManager.getSize(AUTH_CODE_CACHE));
        }
        return Success.of((Object)event.getAuthCode());
    }

    @Override
    public Result<String> queryMarketCode(String authCode) {
        if (logger.isTraceEnabled()) {
            logger.trace("estimate the size of the cache auth_code is " + SqlDbStartupHook.cacheManager.getSize(AUTH_CODE_CACHE));
        }
        String value = (String)SqlDbStartupHook.cacheManager.get(AUTH_CODE_CACHE, authCode);
        if (logger.isTraceEnabled()) {
            logger.trace("retrieve cache auth_code with key " + authCode + " value " + value);
        }
        if (value != null) {
            return Success.of((Object)value);
        }
        return Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"auth code not found"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createHost(HostCreatedEvent event) {
        Result result;
        String insertHost = "INSERT INTO host_t (host_id, host, org_name, org_desc, org_owner, jwk, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        String insertHostKey = "INSERT INTO host_key_t (host_id, kid, public_key, private_key, key_type, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?)";
        Map map = JsonMapper.string2Map((String)event.getValue());
        Connection conn = null;
        try {
            int count;
            KeyPair longKeyPair = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String longKeyId = HashUtil.generateUUID();
            KeyPair currKeyPair = KeyUtil.generateKeyPair((String)"RSA", (int)2048);
            String currKeyId = HashUtil.generateUUID();
            if (logger.isTraceEnabled()) {
                logger.trace("longKeyId is " + longKeyId + " currKeyId is " + currKeyId);
            }
            String jwk = KeyUtil.generateJwk((PublicKey)longKeyPair.getPublic(), (String)longKeyId, (PublicKey)currKeyPair.getPublic(), (String)currKeyId, null, null);
            if (logger.isTraceEnabled()) {
                logger.trace("jwk is " + jwk);
            }
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("INSERT INTO host_t (host_id, host, org_name, org_desc, org_owner, jwk, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                statement.setString(1, event.getId());
                statement.setString(2, event.getHost());
                statement.setString(3, event.getName());
                statement.setString(4, event.getDesc());
                statement.setString(5, event.getOwner());
                statement.setString(6, jwk);
                statement.setString(7, event.getEventId().getId());
                statement.setTimestamp(8, new Timestamp(event.getTimestamp()));
                count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the host " + event.getHost());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            statement = conn.prepareStatement("INSERT INTO host_key_t (host_id, kid, public_key, private_key, key_type, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?)");
            try {
                statement.setString(1, event.getId());
                statement.setString(2, longKeyId);
                statement.setString(3, KeyUtil.serializePublicKey((PublicKey)longKeyPair.getPublic()));
                statement.setString(4, KeyUtil.serializePrivateKey((PrivateKey)longKeyPair.getPrivate()));
                statement.setString(5, "L");
                statement.setString(6, event.getEventId().getId());
                statement.setTimestamp(7, new Timestamp(event.getTimestamp()));
                count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the host_key for host " + event.getHost() + " kid " + longKeyId);
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = conn.prepareStatement("INSERT INTO host_key_t (host_id, kid, public_key, private_key, key_type, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?, ?, ?)");
            try {
                statement.setString(1, event.getId());
                statement.setString(2, currKeyId);
                statement.setString(3, KeyUtil.serializePublicKey((PublicKey)currKeyPair.getPublic()));
                statement.setString(4, KeyUtil.serializePrivateKey((PrivateKey)currKeyPair.getPrivate()));
                statement.setString(5, "C");
                statement.setString(6, event.getEventId().getId());
                statement.setTimestamp(7, new Timestamp(event.getTimestamp()));
                count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the host_key for host " + event.getHost() + " kid " + longKeyId);
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException:", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateHost(HostUpdatedEvent event) {
        String updateHost = "UPDATE host_t SET org_name = ?, org_desc = ?, org_owner = ?, update_user = ? update_timestamp = ? WHERE host_id = ?";
        Result result = null;
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE host_t SET org_name = ?, org_desc = ?, org_owner = ?, update_user = ? update_timestamp = ? WHERE host_id = ?");){
                if (event.getName() != null) {
                    statement.setString(1, event.getName());
                } else {
                    statement.setNull(1, 0);
                }
                if (event.getDesc() != null) {
                    statement.setString(2, event.getDesc());
                } else {
                    statement.setNull(2, 0);
                }
                if (event.getOwner() != null) {
                    statement.setString(3, event.getOwner());
                } else {
                    statement.setNull(3, 0);
                }
                statement.setString(4, event.getEventId().getId());
                statement.setTimestamp(5, new Timestamp(event.getTimestamp()));
                statement.setString(6, event.getId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is updated by host " + event.getHost());
                    Result result2 = result;
                    return result2;
                }
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            }
            conn.commit();
            result = Success.of((Object)event.getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException:", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> deleteHost(HostDeletedEvent event) {
        Result result;
        String deleteHost = "DELETE from host_t WHERE host_id = ?";
        String deleteHostKey = "DELETE from host_key_t WHERE host_id = ?";
        Connection conn = null;
        try {
            int count;
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("DELETE from host_key_t WHERE host_id = ?");){
                statement.setString(1, event.getId());
                count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no host_key record is deleted for host " + event.getHost());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            statement = conn.prepareStatement("DELETE from host_t WHERE host_id = ?");
            try {
                statement.setString(1, event.getId());
                count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no host record is deleted for host " + event.getHost());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryHostByHost(String host) {
        Result result;
        String queryHostByHost = "SELECT * from host_t WHERE host = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from host_t WHERE host = ?");){
                statement.setString(1, host);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host_id", resultSet.getString("host_id"));
                        map.put("host", resultSet.getString("host"));
                        map.put("orgName", resultSet.getString("org_name"));
                        map.put("orgDesc", resultSet.getString("org_desc"));
                        map.put("orgOwner", resultSet.getString("org_owner"));
                        map.put("jwk", resultSet.getString("jwk"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"host with host ", host})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryHostById(String id) {
        Result result;
        String queryHostById = "SELECT * from host_t WHERE host_id = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from host_t WHERE host_id = ?");){
                statement.setString(1, id);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host_id", resultSet.getString("host_id"));
                        map.put("host", resultSet.getString("host"));
                        map.put("orgName", resultSet.getString("org_name"));
                        map.put("orgDesc", resultSet.getString("org_desc"));
                        map.put("orgOwner", resultSet.getString("org_owner"));
                        map.put("jwk", resultSet.getString("jwk"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"host with id", id})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryHostByOwner(String owner) {
        Result result;
        String queryHostByOwner = "SELECT * from host_t WHERE org_owner = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from host_t WHERE org_owner = ?");){
                statement.setString(1, owner);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("host_id", resultSet.getString("host_id"));
                        map.put("host", resultSet.getString("host"));
                        map.put("orgName", resultSet.getString("org_name"));
                        map.put("orgDesc", resultSet.getString("org_desc"));
                        map.put("orgOwner", resultSet.getString("org_owner"));
                        map.put("jwk", resultSet.getString("jwk"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"host with owner ", owner})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> createConfig(ConfigCreatedEvent event) {
        Result result;
        String insertHost = "INSERT INTO configuration_t (configuration_id, configuration_type, infrastructure_type_id, class_path, configuration_description, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?)";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("INSERT INTO configuration_t (configuration_id, configuration_type, infrastructure_type_id, class_path, configuration_description, update_user, update_timestamp) VALUES (?, ?, ?, ?, ?,   ?, ?)");){
                statement.setString(1, event.getConfigId());
                statement.setString(2, event.getConfigType());
                statement.setString(3, event.getInfraType());
                statement.setString(4, event.getClassPath());
                statement.setString(5, event.getConfigDesc());
                statement.setString(6, event.getEventId().getId());
                statement.setTimestamp(7, new Timestamp(event.getTimestamp()));
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "failed to insert the configuration with id " + event.getConfigId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getConfigId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> updateConfig(ConfigUpdatedEvent event) {
        String updateHost = "UPDATE configuration_t SET configuration_type = ?, infrastructure_type_id = ?, class_path = ?, configuration_description = ?, update_user = ? update_timestamp = ? WHERE configuration_id = ?";
        Result result = null;
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("UPDATE configuration_t SET configuration_type = ?, infrastructure_type_id = ?, class_path = ?, configuration_description = ?, update_user = ? update_timestamp = ? WHERE configuration_id = ?");){
                if (event.getConfigType() != null) {
                    statement.setString(1, event.getConfigType());
                } else {
                    statement.setNull(1, 0);
                }
                if (event.getInfraType() != null) {
                    statement.setString(2, event.getInfraType());
                } else {
                    statement.setNull(2, 0);
                }
                if (event.getClassPath() != null) {
                    statement.setString(3, event.getClassPath());
                } else {
                    statement.setNull(3, 0);
                }
                if (event.getConfigDesc() != null) {
                    statement.setString(4, event.getConfigDesc());
                } else {
                    statement.setNull(4, 0);
                }
                statement.setString(5, event.getEventId().getId());
                statement.setTimestamp(6, new Timestamp(event.getTimestamp()));
                statement.setString(7, event.getConfigId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no record is updated by configuration id " + event.getConfigId());
                    Result result2 = result;
                    return result2;
                }
                this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            }
            conn.commit();
            result = Success.of((Object)event.getConfigId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> deleteConfig(ConfigDeletedEvent event) {
        Result result;
        String deleteHost = "DELETE from configuration_t WHERE configuration_id = ?";
        Connection conn = null;
        try {
            conn = SqlDbStartupHook.ds.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement statement = conn.prepareStatement("DELETE from configuration_t WHERE configuration_id = ?");){
                statement.setString(1, event.getConfigId());
                int count = statement.executeUpdate();
                if (count == 0) {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), false, "no configuration record is deleted for id " + event.getConfigId());
                } else {
                    this.insertNotification(conn, event.getEventId().getId(), event.getEventId().getNonce(), AvroConverter.toJson((SpecificRecord)event, (boolean)false), true, null);
                }
            }
            this.updateNonce(conn, event.getEventId().getNonce() + 1L, event.getEventId().getId());
            conn.commit();
            result = Success.of((Object)event.getEventId().getId());
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryConfig() {
        Result result;
        String queryConfig = "SELECT * from configuration_t";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from configuration_t");
                 ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    map.put("configId", resultSet.getString("configuration_id"));
                    map.put("configType", resultSet.getString("configuration_type"));
                    map.put("infraType", resultSet.getString("infrastructure_type_id"));
                    map.put("classPath", resultSet.getString("class_path"));
                    map.put("configDesc", resultSet.getString("configuration_desc"));
                    map.put("updateUser", resultSet.getString("update_user"));
                    map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"configuration entry is registered"})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryConfigById(String configId) {
        Result result;
        String queryConfigById = "SELECT * from configuration_t WHERE configuration_id = ?";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from configuration_t WHERE configuration_id = ?");){
                statement.setString(1, configId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("configId", resultSet.getString("configuration_id"));
                        map.put("configType", resultSet.getString("configuration_type"));
                        map.put("infraType", resultSet.getString("infrastructure_type_id"));
                        map.put("classPath", resultSet.getString("class_path"));
                        map.put("configDesc", resultSet.getString("configuration_desc"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.size() == 0 ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"configuration with id ", configId})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryCurrentHostKey(String hostId) {
        Result result;
        String queryConfigById = "SELECT * from host_key_t WHERE host_id = ? AND key_type = 'C'";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from host_key_t WHERE host_id = ? AND key_type = 'C'");){
                statement.setString(1, hostId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("hostId", resultSet.getString("host_id"));
                        map.put("kid", resultSet.getString("kid"));
                        map.put("publicKey", resultSet.getString("public_key"));
                        map.put("privateKey", resultSet.getString("private_key"));
                        map.put("keyType", resultSet.getString("key_type"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.isEmpty() ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"host key with id", hostId})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }

    @Override
    public Result<Map<String, Object>> queryLongLiveHostKey(String hostId) {
        Result result;
        String queryConfigById = "SELECT * from host_key_t WHERE host_id = ? AND key_type = 'L'";
        try (Connection conn = SqlDbStartupHook.ds.getConnection();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            try (PreparedStatement statement = conn.prepareStatement("SELECT * from host_key_t WHERE host_id = ? AND key_type = 'L'");){
                statement.setString(1, hostId);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        map.put("hostId", resultSet.getString("host_id"));
                        map.put("kid", resultSet.getString("kid"));
                        map.put("publicKey", resultSet.getString("public_key"));
                        map.put("privateKey", resultSet.getString("private_key"));
                        map.put("keyType", resultSet.getString("key_type"));
                        map.put("updateUser", resultSet.getString("update_user"));
                        map.put("updateTimestamp", resultSet.getTimestamp("update_timestamp"));
                    }
                }
            }
            result = map.isEmpty() ? Failure.of((Status)new Status(OBJECT_NOT_FOUND, new Object[]{"host key with id", hostId})) : Success.of(map);
        }
        catch (SQLException e) {
            logger.error("SQLException:", (Throwable)e);
            result = Failure.of((Status)new Status(SQL_EXCEPTION, new Object[]{e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            result = Failure.of((Status)new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()}));
        }
        return result;
    }
}

