/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal;

import com.networknt.client.Http2Client;
import com.networknt.client.simplepool.SimpleConnectionHolder;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.server.Server;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import net.lightapi.portal.PortalClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;

public class HybridQueryClient {
    static final Logger logger = LoggerFactory.getLogger(HybridQueryClient.class);
    static final String FAILED_TO_POPULATE_HEADER = "ERR12050";
    public static final PortalClientConfig config = (PortalClientConfig)Config.getInstance().getJsonObjectConfig("portal-client", PortalClientConfig.class);
    static String tag = Server.getServerConfig().getEnvironment();
    static Cluster cluster = (Cluster)SingletonServiceFactory.getBean(Cluster.class);
    static Http2Client client = Http2Client.getInstance();
    static final String GENERIC_EXCEPTION = "ERR10014";
    static Map<String, ClientConnection> connCache = new ConcurrentHashMap<String, ClientConnection>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryWithToken(String command, String token) {
        Result result = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            String host = cluster.serviceToUrl("https", config.getPortalQueryServiceId(), tag, null);
            if (logger.isTraceEnabled()) {
                logger.trace("serviceId " + config.getPortalQueryServiceId() + " with result " + host);
            }
            URI uri = new URI(host);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference reference = new AtomicReference();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, StandardCharsets.UTF_8);
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = ((ClientResponse)reference.get()).getResponseCode();
            String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                result = Failure.of((Status)status);
            } else {
                result = Success.of((Object)body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
            result = Failure.of((Status)status);
        }
        finally {
            client.restore(connectionToken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryExchangeUrl(String command, HttpServerExchange exchange, String url) {
        SimpleConnectionHolder.ConnectionToken connectionToken;
        Result result;
        block7: {
            result = null;
            connectionToken = null;
            try {
                URI uri = new URI(url);
                connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
                ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference reference = new AtomicReference();
                String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
                String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
                if (token != null) {
                    request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
                }
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (logger.isTraceEnabled()) {
                    logger.trace("statusCode = " + statusCode + " body = " + body);
                }
                if (statusCode != 200) {
                    Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                    result = Failure.of((Status)status);
                    break block7;
                }
                result = Success.of((Object)body);
            }
            catch (Exception e) {
                try {
                    logger.error("Exception:", (Throwable)e);
                    Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
                    result = Failure.of((Status)status);
                }
                catch (Throwable throwable) {
                    client.restore(connectionToken);
                    throw throwable;
                }
                client.restore(connectionToken);
            }
        }
        client.restore(connectionToken);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryExchange(String command, HttpServerExchange exchange) {
        Result result = null;
        SimpleConnectionHolder.ConnectionToken connectionToken = null;
        try {
            String host = cluster.serviceToUrl("https", config.getPortalQueryServiceId(), tag, null);
            if (logger.isTraceEnabled()) {
                logger.trace("serviceId " + config.getPortalQueryServiceId() + " with result " + host);
            }
            URI uri = new URI(host);
            connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
            ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference reference = new AtomicReference();
            String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (token != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
            } else {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + config.getBootstrapToken());
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = ((ClientResponse)reference.get()).getResponseCode();
            String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode != 200) {
                Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                result = Failure.of((Status)status);
            } else {
                result = Success.of((Object)body);
            }
            client.restore(connectionToken);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
            result = Failure.of((Status)status);
        }
        finally {
            client.restore(connectionToken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryUrl(String command, String url) {
        SimpleConnectionHolder.ConnectionToken connectionToken;
        Result result;
        block5: {
            result = null;
            connectionToken = null;
            try {
                URI uri = new URI(url);
                connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
                ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference reference = new AtomicReference();
                String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode != 200) {
                    Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                    result = Failure.of((Status)status);
                    break block5;
                }
                result = Success.of((Object)body);
            }
            catch (Exception e) {
                try {
                    logger.error("Exception:", (Throwable)e);
                    Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
                    result = Failure.of((Status)status);
                }
                catch (Throwable throwable) {
                    client.restore(connectionToken);
                    throw throwable;
                }
                client.restore(connectionToken);
            }
        }
        client.restore(connectionToken);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> callQueryTokenUrl(String command, String token, String url) {
        SimpleConnectionHolder.ConnectionToken connectionToken;
        Result result;
        block5: {
            result = null;
            connectionToken = null;
            try {
                URI uri = new URI(url);
                connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
                ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference reference = new AtomicReference();
                String message = "/portal/query?cmd=" + URLEncoder.encode(command, "UTF-8");
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
                request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + token);
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode != 200) {
                    Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                    result = Failure.of((Status)status);
                    break block5;
                }
                result = Success.of((Object)body);
            }
            catch (Exception e) {
                try {
                    logger.error("Exception:", (Throwable)e);
                    Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
                    result = Failure.of((Status)status);
                }
                catch (Throwable throwable) {
                    client.restore(connectionToken);
                    throw throwable;
                }
                client.restore(connectionToken);
            }
        }
        client.restore(connectionToken);
        return result;
    }

    public static Result<String> getUserByEmail(HttpServerExchange exchange, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getUserByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getUserByEmail(String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(command, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(command, token);
    }

    public static Result<String> getUserById(HttpServerExchange exchange, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getUserById(HttpServerExchange exchange, String url, String userId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getUserById(String userId, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"queryUserById\",\"version\":\"0.1.0\",\"data\":{\"userId\":\"%s\"}}", userId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(command, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(command, token);
    }

    public static Result<String> getNonceByEmail(HttpServerExchange exchange, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNonceByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> getNonceByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNonceByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getCity(HttpServerExchange exchange, String country, String province, String city) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getCity\",\"version\":\"0.1.0\",\"data\":{\"country\":\"%s\",\"province\":\"%s\",\"city\":\"%s\"}}", country, province, city);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(command, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(command, exchange);
    }

    public static Result<String> loginUser(String url, String email, String password) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"loginUser\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"password\":\"%s\"}}", email, password);
        return HybridQueryClient.callQueryUrl(command, url);
    }

    public static Result<String> getMessageByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPrivateMessage\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getNotificationByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getNotification\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getEntity(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getEntity\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getStatusByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getStatusByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getStatusByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getStatusByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getWebsiteByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getWebsiteByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getWebsiteByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"covid\",\"action\":\"getWebsiteByEmail\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getPaymentByEmail(HttpServerExchange exchange, String url, String email) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPayment\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getPaymentByEmail(String url, String email, String token) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getPayment\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\"}}", email);
        return HybridQueryClient.callQueryTokenUrl(command, token, url);
    }

    public static Result<String> getCustomerOrderByEmail(HttpServerExchange exchange, String url, String email, int offset, int limit) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getCustomerOrder\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"offset\":%d,\"limit\":%d}}", email, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getMerchantOrderByEmail(HttpServerExchange exchange, String url, String email, String orderStatus, int offset, int limit) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"getMerchantOrder\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"status\":\"%s\",\"offset\":%d,\"limit\":%d}}", email, orderStatus, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getClientById(HttpServerExchange exchange, String url, String clientId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getClientById(String token, String url, String clientId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        return HybridQueryClient.callQueryTokenUrl(s, token, url);
    }

    public static Result<String> getClientById(String token, String clientId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getClientById\",\"version\":\"0.1.0\",\"data\":{\"clientId\":\"%s\"}}", clientId);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s, token);
    }

    public static Result<String> getClient(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getClient\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getService(HttpServerExchange exchange, String url, String host, String style, int offset, int limit) {
        String s = style != null ? String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getService\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"style\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, style, offset, limit) : String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getService\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getServiceById(HttpServerExchange exchange, String url, String serviceId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getServiceById\",\"version\":\"0.1.0\",\"data\":{\"serviceId\":\"%s\"}}", serviceId);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getServiceRoleById(HttpServerExchange exchange, String url, String serviceId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getServiceRoleById\",\"version\":\"0.1.0\",\"data\":{\"serviceId\":\"%s\"}}", serviceId);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRefreshTokenDetail(HttpServerExchange exchange, String url, String refreshToken) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefreshTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refreshToken\":\"%s\"}}", refreshToken);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRefreshToken(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefreshToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getAuthCodeDetail(HttpServerExchange exchange, String url, String authCode) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getAuthCodeDetail\",\"version\":\"0.1.0\",\"data\":{\"authCode\":\"%s\"}}", authCode);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getAuthCodeDetail(String authCode, String token) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getAuthCodeDetail\",\"version\":\"0.1.0\",\"data\":{\"authCode\":\"%s\"}}", authCode);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s, token);
    }

    public static Result<String> getAuthCode(HttpServerExchange exchange, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getAuthCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s, exchange);
    }

    public static Result<String> getAuthCode(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getAuthCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRefTokenDetail(HttpServerExchange exchange, String url, String refToken) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refToken\":\"%s\"}}", refToken);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRefTokenDetail(String refToken, String token) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefTokenDetail\",\"version\":\"0.1.0\",\"data\":{\"refToken\":\"%s\"}}", refToken);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryTokenUrl(s, token, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryWithToken(s, token);
    }

    public static Result<String> getRefToken(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRefToken\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getProviderDetail(HttpServerExchange exchange, String url, String providerId) {
        String command = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getProviderDetail\",\"version\":\"0.1.0\",\"data\":{\"providerId\":\"%s\"}}", providerId);
        return HybridQueryClient.callQueryExchangeUrl(command, exchange, url);
    }

    public static Result<String> getProvider(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getProvider\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String> getHosts() {
        SimpleConnectionHolder.ConnectionToken connectionToken;
        Result result;
        block5: {
            String path = "/r/data?name=host";
            result = null;
            connectionToken = null;
            try {
                String host = cluster.serviceToUrl("https", config.getPortalReferenceServiceId(), tag, null);
                URI uri = new URI(host);
                connectionToken = client.borrow(uri, Http2Client.WORKER, client.getDefaultXnioSsl(), Http2Client.BUFFER_POOL, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true));
                ClientConnection connection = (ClientConnection)connectionToken.getRawConnection();
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference reference = new AtomicReference();
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await();
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode != 200) {
                    Status status = (Status)Config.getInstance().getMapper().readValue(body, Status.class);
                    result = Failure.of((Status)status);
                    break block5;
                }
                result = Success.of((Object)body);
            }
            catch (Exception e) {
                try {
                    logger.error("Exception:", (Throwable)e);
                    Status status = new Status(GENERIC_EXCEPTION, new Object[]{e.getMessage()});
                    result = Failure.of((Status)status);
                }
                catch (Throwable throwable) {
                    client.restore(connectionToken);
                    throw throwable;
                }
                client.restore(connectionToken);
            }
        }
        client.restore(connectionToken);
        return result;
    }

    public static Result<String> getHost(HttpServerExchange exchange, String url, String host) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getHost(HttpServerExchange exchange, String host) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s, exchange);
    }

    public static Result<String> getCategoryByName(HttpServerExchange exchange, String url, String host, String name) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getCategoryByName\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"name\":\"%s\"}}", host, name);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getCategory(HttpServerExchange exchange, String url, String host) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getCategory\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\"}}", host);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getBlogById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getBlogById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getBlogById(HttpServerExchange exchange, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getBlogById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchange(s, exchange);
    }

    public static Result<String> getBlogList(HttpServerExchange exchange, String url, String host, int offset, int limit, List<String> categories, List<String> tags) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", "lightapi.net");
        map.put("service", "market");
        map.put("action", "getBlogList");
        map.put("version", "0.1.0");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("host", host);
        dataMap.put("offset", offset);
        dataMap.put("limit", limit);
        dataMap.put("categories", categories);
        dataMap.put("tags", tags);
        map.put("data", dataMap);
        return HybridQueryClient.callQueryExchangeUrl(JsonMapper.toJson(map), exchange, url);
    }

    public static Result<String> getBlog(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getBlog\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getDocumentById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getDocumentById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getDocument(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getDocument\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getNewsById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getNewsById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getNews(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getNews\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getPageById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getPageById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getPage(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getPage\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getTemplateById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getTemplateById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getTemplate(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getTemplate\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getTags(String url, String host, String app) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getTags\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"app\":\"%s\",\"local\":true}}", host, app);
        return HybridQueryClient.callQueryUrl(s, url);
    }

    public static Result<String> getError(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getError\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getErrorByCode(HttpServerExchange exchange, String url, String host, String errorCode) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getErrorByCode\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"errorCode\":\"%s\"}}", host, errorCode);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getJsonSchema(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getJsonSchema\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getJsonSchemaById(HttpServerExchange exchange, String url, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getJsonSchemaById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getJsonSchemaById(HttpServerExchange exchange, String host, String id) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getJsonSchemaById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"id\":\"%s\"}}", host, id);
        if (config.isPortalByServiceUrl()) {
            return HybridQueryClient.callQueryExchangeUrl(s, exchange, config.getPortalQueryServiceUrl());
        }
        return HybridQueryClient.callQueryExchange(s, exchange);
    }

    public static Result<String> getJsonSchemaList(HttpServerExchange exchange, String url, String host, int offset, int limit, List<String> categories, List<String> tags) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", "lightapi.net");
        map.put("service", "market");
        map.put("action", "getJsonSchemaList");
        map.put("version", "0.1.0");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("host", host);
        dataMap.put("offset", offset);
        dataMap.put("limit", limit);
        dataMap.put("categories", categories);
        dataMap.put("tags", tags);
        map.put("data", dataMap);
        return HybridQueryClient.callQueryExchangeUrl(JsonMapper.toJson(map), exchange, url);
    }

    public static Result<String> getRuleById(HttpServerExchange exchange, String url, String host, String ruleId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRuleById\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"ruleId\":\"%s\"}}", host, ruleId);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRuleByHost(HttpServerExchange exchange, String url, String host, int offset, int limit) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRuleByHost\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"offset\":%s,\"limit\":%s}}", host, offset, limit);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRuleByType(HttpServerExchange exchange, String url, String host, String ruleType) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRuleByType\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"ruleType\":\"%s\"}}", host, ruleType);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }

    public static Result<String> getRuleByGroup(HttpServerExchange exchange, String url, String host, String groupId) {
        String s = String.format("{\"host\":\"lightapi.net\",\"service\":\"market\",\"action\":\"getRuleByGroup\",\"version\":\"0.1.0\",\"data\":{\"host\":\"%s\",\"groupId\":\"%s\"}}", host, groupId);
        return HybridQueryClient.callQueryExchangeUrl(s, exchange, url);
    }
}

