/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.client.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/client/getApp/0.1.0")
public class GetApp
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetApp.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String deliveryOwner;
        String appDesc;
        String appName;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String appId = (String)map.get("appId");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = null;
        }
        if (StringUtils.isBlank((CharSequence)(appName = (String)map.get("appName")))) {
            appName = null;
        }
        if (StringUtils.isBlank((CharSequence)(appDesc = (String)map.get("appDesc")))) {
            appDesc = null;
        }
        Boolean isKafkaApp = (Boolean)map.get("isKafkaApp");
        String operationOwner = (String)map.get("operationOwner");
        if (StringUtils.isBlank((CharSequence)operationOwner)) {
            operationOwner = null;
        }
        if (StringUtils.isBlank((CharSequence)(deliveryOwner = (String)map.get("deliveryOwner")))) {
            deliveryOwner = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} appId = {} appName = {} appDesc = {} isKafkaApp = {} operationOwner = {} deliveryOwner = {}", new Object[]{offset, limit, hostId, appId, appName, appDesc, isKafkaApp, operationOwner, deliveryOwner});
        }
        if ((result = dbProvider.queryApp(offset, limit, hostId, appId, appName, appDesc, isKafkaApp, operationOwner, deliveryOwner)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"app", "hostId:" + hostId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

