
package net.lightapi.portal.client.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a list of apps for the host. This is an endpoint that is used for the portal view apps page.
*/
@ServiceHandler(id="lightapi.net/client/getApp/0.1.0")
public class GetApp implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetApp.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String appId = (String)map.get("appId");
        if(StringUtils.isBlank(appId)) appId = null;
        String appName = (String)map.get("appName");
        if(StringUtils.isBlank(appName)) appName = null;
        String appDesc = (String)map.get("appDesc");
        if(StringUtils.isBlank(appDesc)) appDesc = null;
        Boolean isKafkaApp = (Boolean)map.get("isKafkaApp");
        String operationOwner = (String)map.get("operationOwner");
        if(StringUtils.isBlank(operationOwner)) operationOwner = null;
        String deliveryOwner = (String)map.get("deliveryOwner");
        if(StringUtils.isBlank(deliveryOwner)) deliveryOwner = null;

        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} appId = {} appName = {} appDesc = {} isKafkaApp = {} operationOwner = {} deliveryOwner = {}", offset, limit, hostId, appId, appName, appDesc, isKafkaApp, operationOwner, deliveryOwner);
        Result<String> result = dbProvider.queryApp(offset, limit, hostId, appId, appName, appDesc, isKafkaApp, operationOwner, deliveryOwner);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "app", "hostId:" + hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
